/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.adapter;

import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Uniform;
import org.restlet.data.Method;
import org.restlet.data.Status;
import org.restlet.engine.Edition;
import org.restlet.engine.adapter.Adapter;
import org.restlet.engine.adapter.ClientCall;
import org.restlet.engine.adapter.HttpClientHelper;
import org.restlet.engine.header.Header;
import org.restlet.engine.header.HeaderUtils;
import org.restlet.util.Series;

public class ClientAdapter
extends Adapter {
    public ClientAdapter(Context context) {
        super(context);
    }

    public void commit(final ClientCall httpCall, Request request, Response response) throws Exception {
        if (httpCall != null) {
            if (request.isAsynchronous()) {
                final Uniform userCallback = request.getOnResponse();
                httpCall.sendRequest(request, response, new Uniform(){

                    public void handle(Request request, Response response) {
                        try {
                            ClientAdapter.this.updateResponse(response, new Status(httpCall.getStatusCode(), null, httpCall.getReasonPhrase(), null), httpCall);
                            if (userCallback != null) {
                                userCallback.handle(request, response);
                            }
                        }
                        catch (Throwable t) {
                            ClientAdapter.this.getLogger().log(Level.WARNING, "Unexpected error or exception inside the user call back", t);
                        }
                    }
                });
            } else if (Edition.CURRENT == Edition.GWT) {
                System.err.println("HTTP client calls must have a callback in the GWT edition");
            } else {
                this.updateResponse(response, httpCall.sendRequest(request), httpCall);
            }
        }
    }

    protected void readResponseHeaders(ClientCall httpCall, Response response) {
        try {
            Series<Header> responseHeaders = httpCall.getResponseHeaders();
            response.getAttributes().put("org.restlet.http.headers", responseHeaders);
            HeaderUtils.copyResponseTransportHeaders(responseHeaders, response);
        }
        catch (Exception e) {
            this.getLogger().log(Level.FINE, "An error occured during the processing of the HTTP response.", e);
            response.setStatus(Status.CONNECTOR_ERROR_INTERNAL, e);
        }
    }

    public ClientCall toSpecific(HttpClientHelper client, Request request) {
        ClientCall result = client.create(request);
        if (result != null) {
            HeaderUtils.addGeneralHeaders(request, result.getRequestHeaders());
            if (request.getEntity() != null) {
                HeaderUtils.addEntityHeaders(request.getEntity(), result.getRequestHeaders());
            }
            HeaderUtils.addRequestHeaders(request, result.getRequestHeaders());
        }
        return result;
    }

    public void updateResponse(Response response, Status status, ClientCall httpCall) {
        response.setStatus(status);
        response.getServerInfo().setAddress(httpCall.getServerAddress());
        response.getServerInfo().setPort(httpCall.getServerPort());
        this.readResponseHeaders(httpCall, response);
        response.setEntity(httpCall.getResponseEntity(response));
        if (response.getEntity() != null) {
            if (response.getEntity().isEmpty()) {
                response.getEntity().release();
            } else if (response.getRequest().getMethod().equals(Method.HEAD)) {
                response.getEntity().release();
            } else if (response.getStatus().equals(Status.SUCCESS_NO_CONTENT)) {
                response.getEntity().release();
            } else if (response.getStatus().equals(Status.SUCCESS_RESET_CONTENT)) {
                response.getEntity().release();
                response.setEntity(null);
            } else if (response.getStatus().equals(Status.REDIRECTION_NOT_MODIFIED)) {
                response.getEntity().release();
            } else if (response.getStatus().isInformational()) {
                response.getEntity().release();
                response.setEntity(null);
            }
        }
    }
}

