/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.HealthDataCache;
import org.apache.log4j.Logger;

public class ReadHealthDataStage
extends AbstractBaseStage {
    private static final Logger LOG = Logger.getLogger((String)ReadHealthDataStage.class.getName());
    HealthDataCache _cache = new HealthDataCache();

    @Override
    public void process(ClusterEvent event) throws Exception {
        long startTime = System.currentTimeMillis();
        HelixManager manager = (HelixManager)event.getAttribute("helixmanager");
        if (manager == null) {
            throw new StageException("HelixManager attribute value is null");
        }
        HelixDataAccessor accessor = manager.getHelixDataAccessor();
        this._cache.refresh(accessor);
        event.addAttribute("HealthDataCache", this._cache);
        long processLatency = System.currentTimeMillis() - startTime;
        this.addLatencyToMonitor(event, processLatency);
    }
}

