/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.uberfire.backend.server.util.TextUtil;
import org.uberfire.io.FileSystemType;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class UserServicesBackendImpl {
    @Inject
    @Named(value="configIO")
    private IOService ioService;
    private FileSystem bootstrapRoot = null;

    private FileSystem getBootstrapRoot() {
        Iterator fsIterator;
        if (this.bootstrapRoot == null && (fsIterator = this.ioService.getFileSystems((FileSystemType)FileSystemType.Bootstrap.BOOTSTRAP_INSTANCE).iterator()).hasNext()) {
            this.bootstrapRoot = (FileSystem)fsIterator.next();
        }
        return this.bootstrapRoot;
    }

    public Path buildPath(String _userName, String serviceType, String relativePath) {
        String resultUserName = TextUtil.normalizeUserName(_userName);
        if (relativePath != null && !"".equals(relativePath)) {
            return this.getBootstrapRoot().getPath(resultUserName + "-uf-user", new String[]{serviceType, relativePath});
        }
        return this.getBootstrapRoot().getPath(resultUserName + "-uf-user", new String[]{serviceType});
    }

    public Collection<Path> getAllUsersData(String serviceType, String relativePath) {
        ArrayList<Path> result = new ArrayList<Path>();
        for (Path path : this.getBootstrapRoot().getRootDirectories()) {
            Path _path = relativePath != null && !"".equals(relativePath) ? path.resolve(serviceType).resolve(relativePath) : path.resolve(serviceType);
            if (!this.ioService.exists(_path)) continue;
            result.add(_path);
        }
        return result;
    }
}

