/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.config;

import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import javax.naming.InitialContext;
import org.uberfire.backend.server.config.ConfigGroup;
import org.uberfire.backend.server.config.ConfigGroupMarshaller;
import org.uberfire.backend.server.config.ConfigType;
import org.uberfire.backend.server.config.ConfigurationService;
import org.uberfire.backend.server.config.OrgUnit;
import org.uberfire.backend.server.config.Repository;
import org.uberfire.backend.server.config.SystemRepositoryChangedEvent;
import org.uberfire.backend.server.config.watch.AsyncConfigWatchService;
import org.uberfire.backend.server.config.watch.AsyncWatchServiceCallback;
import org.uberfire.backend.server.config.watch.ConfigServiceWatchServiceExecutor;
import org.uberfire.backend.server.config.watch.ConfigServiceWatchServiceExecutorImpl;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.commons.async.DescriptiveRunnable;
import org.uberfire.io.FileSystemType;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.WatchContext;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Option;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardWatchEventKind;
import org.uberfire.java.nio.file.WatchEvent;
import org.uberfire.java.nio.file.WatchKey;
import org.uberfire.java.nio.file.WatchService;
import org.uberfire.security.Identity;

@ApplicationScoped
public class ConfigurationServiceImpl
implements ConfigurationService,
AsyncWatchServiceCallback {
    private static final String MONITOR_DISABLED = "org.uberfire.sys.repo.monitor.disabled";
    private static final String INVALID_FILENAME_CHARS = "[\\,/,:,*,?,\",<,>,|]";
    @Inject
    @Named(value="system")
    private org.uberfire.backend.repositories.Repository systemRepository;
    @Inject
    private ConfigGroupMarshaller marshaller;
    @Inject
    private Identity identity;
    private final Map<ConfigType, List<ConfigGroup>> configuration = new ConcurrentHashMap<ConfigType, List<ConfigGroup>>();
    private AtomicLong localLastModifiedValue = new AtomicLong(-1L);
    @Inject
    @Named(value="configIO")
    private IOService ioService;
    @Inject
    @Repository
    private Event<SystemRepositoryChangedEvent> repoChangedEvent;
    @Inject
    @OrgUnit
    private Event<SystemRepositoryChangedEvent> orgUnitChangedEvent;
    @Inject
    private Event<SystemRepositoryChangedEvent> changedEvent;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private ConfigServiceWatchServiceExecutor executor = null;
    private CheckConfigurationUpdates configUpdates = null;
    private WatchService watchService = null;
    private FileSystem fs;

    @PostConstruct
    public void setup() {
        try {
            this.fs = this.ioService.newFileSystem(URI.create(this.systemRepository.getUri()), this.systemRepository.getEnvironment(), (FileSystemType)FileSystemType.Bootstrap.BOOTSTRAP_INSTANCE);
            this.updateLastModified();
        }
        catch (FileSystemAlreadyExistsException e) {
            this.fs = this.ioService.getFileSystem(URI.create(this.systemRepository.getUri()));
        }
        Path defaultRoot = (Path)this.fs.getRootDirectories().iterator().next();
        for (Path path : this.fs.getRootDirectories()) {
            if (!path.toUri().toString().contains("/master@")) continue;
            defaultRoot = path;
            break;
        }
        this.systemRepository.setRoot(Paths.convert(defaultRoot));
        if (System.getProperty(MONITOR_DISABLED) == null) {
            this.watchService = this.fs.newWatchService();
            this.configUpdates = new CheckConfigurationUpdates(this.watchService);
            final ConfigServiceWatchServiceExecutor configServiceWatchServiceExecutor = this.getWatchServiceExecutor();
            this.executorService.execute((Runnable)new DescriptiveRunnable(){

                public String getDescription() {
                    return ConfigurationServiceImpl.this.configUpdates.getDescription();
                }

                public void run() {
                    ConfigurationServiceImpl.this.configUpdates.execute(configServiceWatchServiceExecutor);
                }
            });
        }
    }

    @PreDestroy
    public void shutdown() {
        if (this.configUpdates != null) {
            this.configUpdates.deactivate();
        }
        if (this.watchService != null) {
            this.watchService.close();
        }
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
                if (!this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                    System.err.println("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public List<ConfigGroup> getConfiguration(final ConfigType type) {
        if (this.configuration.containsKey(type)) {
            return this.configuration.get(type);
        }
        ArrayList<ConfigGroup> configGroups = new ArrayList<ConfigGroup>();
        DirectoryStream foundConfigs = this.ioService.newDirectoryStream(this.ioService.get(this.systemRepository.getUri(), new String[0]), (DirectoryStream.Filter)new DirectoryStream.Filter<Path>(){

            public boolean accept(Path entry) throws IOException {
                return !Files.isDirectory((Path)entry, (LinkOption[])new LinkOption[0]) && !entry.getFileName().toString().startsWith(".") && entry.getFileName().toString().endsWith(type.getExt());
            }
        });
        Iterator it = foundConfigs.iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                String content = this.ioService.readAllString((Path)it.next());
                ConfigGroup configGroup = this.marshaller.unmarshall(content);
                configGroups.add(configGroup);
            }
            this.configuration.put(type, configGroups);
        }
        return configGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addConfiguration(ConfigGroup configGroup) {
        String filename = configGroup.getName().replaceAll(INVALID_FILENAME_CHARS, "_");
        Path filePath = this.ioService.get(this.systemRepository.getUri(), new String[0]).resolve(filename + configGroup.getType().getExt());
        if (this.ioService.exists(filePath)) {
            return true;
        }
        CommentedOption commentedOption = new CommentedOption(this.getIdentityName(), "Created config " + filePath.getFileName());
        try {
            this.ioService.startBatch(new Option[0]);
            this.ioService.write(filePath, this.marshaller.marshall(configGroup), new OpenOption[]{commentedOption});
            this.updateLastModified();
        }
        finally {
            this.ioService.endBatch(new Option[0]);
        }
        this.configuration.remove(configGroup.getType());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateConfiguration(ConfigGroup configGroup) {
        String filename = configGroup.getName().replaceAll(INVALID_FILENAME_CHARS, "_");
        Path filePath = this.ioService.get(this.systemRepository.getUri(), new String[0]).resolve(filename + configGroup.getType().getExt());
        CommentedOption commentedOption = new CommentedOption(this.getIdentityName(), "Updated config " + filePath.getFileName());
        try {
            this.ioService.startBatch(new Option[0]);
            this.ioService.write(filePath, this.marshaller.marshall(configGroup), new OpenOption[]{commentedOption});
            this.updateLastModified();
        }
        finally {
            this.ioService.endBatch(new Option[0]);
        }
        this.configuration.remove(configGroup.getType());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeConfiguration(ConfigGroup configGroup) {
        boolean result;
        this.configuration.remove(configGroup.getType());
        String filename = configGroup.getName().replaceAll(INVALID_FILENAME_CHARS, "_");
        Path filePath = this.ioService.get(this.systemRepository.getUri(), new String[0]).resolve(filename + configGroup.getType().getExt());
        if (!this.ioService.exists(filePath)) {
            return true;
        }
        try {
            this.ioService.startBatch(new Option[0]);
            result = this.ioService.deleteIfExists(filePath, new DeleteOption[0]);
            if (result) {
                this.updateLastModified();
            }
        }
        finally {
            this.ioService.endBatch(new Option[0]);
        }
        return result;
    }

    protected String getIdentityName() {
        try {
            return this.identity.getName();
        }
        catch (ContextNotActiveException e) {
            return "unknown";
        }
    }

    protected long getLastModified() {
        Path lastModifiedPath = this.ioService.get(this.systemRepository.getUri(), new String[0]).resolve(".lastmodified");
        return this.ioService.getLastModifiedTime(lastModifiedPath).toMillis();
    }

    protected void updateLastModified() {
        Path lastModifiedPath = this.ioService.get(this.systemRepository.getUri(), new String[0]).resolve(".lastmodified");
        CommentedOption commentedOption = new CommentedOption("system", "system repo updated");
        this.ioService.write(lastModifiedPath, new Date().toString().getBytes(), new OpenOption[]{commentedOption});
        this.localLastModifiedValue.set(this.getLastModified());
    }

    @Override
    public void callback(long value) {
        this.localLastModifiedValue.set(value);
        this.configuration.clear();
    }

    protected ConfigServiceWatchServiceExecutor getWatchServiceExecutor() {
        if (this.executor == null) {
            ConfigServiceWatchServiceExecutor _executor = null;
            try {
                _executor = (ConfigServiceWatchServiceExecutor)InitialContext.doLookup("java:module/ConfigServiceWatchServiceExecutorImpl");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (_executor == null) {
                _executor = new ConfigServiceWatchServiceExecutorImpl();
                ((ConfigServiceWatchServiceExecutorImpl)_executor).setConfig(this.systemRepository, this.ioService, this.repoChangedEvent, this.orgUnitChangedEvent, this.changedEvent);
            }
            this.executor = _executor;
        }
        return this.executor;
    }

    private class CheckConfigurationUpdates
    implements AsyncConfigWatchService {
        private final WatchService ws;
        private boolean active = true;

        public CheckConfigurationUpdates(WatchService watchService) {
            this.ws = watchService;
        }

        public void deactivate() {
            this.active = false;
        }

        @Override
        public void execute(ConfigServiceWatchServiceExecutor wsExecutor) {
            while (this.active) {
                try {
                    boolean valid;
                    WatchKey wk;
                    try {
                        wk = this.ws.take();
                    }
                    catch (Exception ex) {
                        break;
                    }
                    List events = wk.pollEvents();
                    boolean markerFileModified = false;
                    for (WatchEvent event : events) {
                        WatchContext context = (WatchContext)event.context();
                        if (event.kind().equals(StandardWatchEventKind.ENTRY_MODIFY)) {
                            if (!context.getOldPath().getFileName().toString().equals(".lastmodified")) continue;
                            markerFileModified = true;
                            break;
                        }
                        if (event.kind().equals(StandardWatchEventKind.ENTRY_CREATE)) {
                            if (!context.getPath().getFileName().toString().equals(".lastmodified")) continue;
                            markerFileModified = true;
                            break;
                        }
                        if (event.kind().equals(StandardWatchEventKind.ENTRY_RENAME)) {
                            if (!context.getOldPath().getFileName().toString().equals(".lastmodified")) continue;
                            markerFileModified = true;
                            break;
                        }
                        if (!event.kind().equals(StandardWatchEventKind.ENTRY_DELETE) || !context.getOldPath().getFileName().toString().equals(".lastmodified")) continue;
                        markerFileModified = true;
                        break;
                    }
                    if (markerFileModified) {
                        wsExecutor.execute(wk, ConfigurationServiceImpl.this.localLastModifiedValue.get(), ConfigurationServiceImpl.this);
                    }
                    if (valid = wk.reset()) continue;
                    break;
                }
                catch (Exception exception) {
                }
            }
        }

        @Override
        public String getDescription() {
            return "Config File Watch Service";
        }
    }
}

