/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.messaging.handling;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixProperty;
import org.apache.helix.NotificationContext;
import org.apache.helix.PropertyKey;
import org.apache.helix.messaging.handling.BatchMessageWrapper;
import org.apache.helix.messaging.handling.CurrentStateUpdate;
import org.apache.helix.messaging.handling.HelixBatchMessageTask;
import org.apache.helix.messaging.handling.HelixTaskResult;
import org.apache.helix.messaging.handling.MessageHandler;
import org.apache.helix.messaging.handling.MessageHandlerFactory;
import org.apache.helix.messaging.handling.MessageTask;
import org.apache.helix.messaging.handling.TaskExecutor;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.Message;
import org.apache.log4j.Logger;

public class BatchMessageHandler
extends MessageHandler {
    private static Logger LOG = Logger.getLogger(BatchMessageHandler.class);
    final MessageHandlerFactory _msgHandlerFty;
    final TaskExecutor _executor;
    final List<Message> _subMessages;
    final List<MessageHandler> _subMessageHandlers;
    final BatchMessageWrapper _batchMsgWrapper;

    public BatchMessageHandler(Message msg, NotificationContext context, MessageHandlerFactory fty, BatchMessageWrapper wrapper, TaskExecutor executor) {
        super(msg, context);
        if (fty == null || executor == null) {
            throw new HelixException("MessageHandlerFactory | TaskExecutor can't be null");
        }
        this._msgHandlerFty = fty;
        this._batchMsgWrapper = wrapper;
        this._executor = executor;
        this._subMessages = new ArrayList<Message>();
        List<String> partitionKeys = this._message.getPartitionNames();
        for (String partitionKey : partitionKeys) {
            Message subMsg = new Message(this._message.getRecord(), UUID.randomUUID().toString());
            subMsg.setPartitionName(partitionKey);
            subMsg.setAttribute(Message.Attributes.PARENT_MSG_ID, this._message.getId());
            subMsg.setBatchMessageMode(false);
            this._subMessages.add(subMsg);
        }
        this._subMessageHandlers = this.createMsgHandlers(this._subMessages, context);
    }

    List<MessageHandler> createMsgHandlers(List<Message> msgs, NotificationContext context) {
        ArrayList<MessageHandler> handlers = new ArrayList<MessageHandler>();
        for (Message msg : msgs) {
            MessageHandler handler = this._msgHandlerFty.createHandler(msg, context);
            handlers.add(handler);
        }
        return handlers;
    }

    public void preHandleMessage() {
        if (this._message.getBatchMessageMode() && this._batchMsgWrapper != null) {
            this._batchMsgWrapper.start(this._message, this._notificationContext);
        }
    }

    public void postHandleMessage() {
        if (this._message.getBatchMessageMode() && this._batchMsgWrapper != null) {
            this._batchMsgWrapper.end(this._message, this._notificationContext);
        }
        HelixManager manager = this._notificationContext.getManager();
        HelixDataAccessor accessor = manager.getHelixDataAccessor();
        ConcurrentHashMap csUpdateMap = (ConcurrentHashMap)this._notificationContext.get(NotificationContext.MapKey.CURRENT_STATE_UPDATE.toString());
        if (csUpdateMap != null) {
            Map<PropertyKey, CurrentState> csUpdate = this.mergeCurStateUpdate(csUpdateMap);
            for (PropertyKey key : csUpdate.keySet()) {
                accessor.updateProperty(key, (HelixProperty)csUpdate.get(key));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HelixTaskResult handleMessage() {
        HelixTaskResult result = null;
        List<Future<HelixTaskResult>> futures = null;
        ArrayList<MessageTask> batchTasks = new ArrayList<MessageTask>();
        BatchMessageWrapper batchMessageWrapper = this._batchMsgWrapper;
        synchronized (batchMessageWrapper) {
            try {
                this.preHandleMessage();
                int exeBatchSize = 1;
                List<String> partitionKeys = this._message.getPartitionNames();
                for (int i = 0; i < partitionKeys.size(); i += exeBatchSize) {
                    HelixBatchMessageTask batchTask;
                    List<MessageHandler> handlers;
                    List<Message> msgs;
                    if (i + exeBatchSize <= partitionKeys.size()) {
                        msgs = this._subMessages.subList(i, i + exeBatchSize);
                        handlers = this._subMessageHandlers.subList(i, i + exeBatchSize);
                        batchTask = new HelixBatchMessageTask(this._message, msgs, handlers, this._notificationContext);
                        batchTasks.add(batchTask);
                        continue;
                    }
                    msgs = this._subMessages.subList(i, i + partitionKeys.size());
                    handlers = this._subMessageHandlers.subList(i, i + partitionKeys.size());
                    batchTask = new HelixBatchMessageTask(this._message, msgs, handlers, this._notificationContext);
                    batchTasks.add(batchTask);
                }
                long timeout = this._message.getExecutionTimeout();
                if (timeout == -1L) {
                    timeout = Long.MAX_VALUE;
                }
                futures = this._executor.invokeAllTasks(batchTasks, timeout, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                LOG.error((Object)("fail to execute batchMsg: " + this._message.getId()), (Throwable)e);
                result = new HelixTaskResult();
                result.setException(e);
            }
            if (futures != null) {
                boolean isBatchTaskSucceed = true;
                for (int i = 0; i < futures.size(); ++i) {
                    Future<HelixTaskResult> future = futures.get(i);
                    MessageTask subTask = (MessageTask)batchTasks.get(i);
                    try {
                        HelixTaskResult subTaskResult = future.get();
                        if (subTaskResult.isSuccess()) continue;
                        isBatchTaskSucceed = false;
                        continue;
                    }
                    catch (InterruptedException e) {
                        isBatchTaskSucceed = false;
                        LOG.error((Object)("interrupted in executing batch-msg: " + this._message.getId() + ", sub-msg: " + subTask.getTaskId()), (Throwable)e);
                        continue;
                    }
                    catch (ExecutionException e) {
                        isBatchTaskSucceed = false;
                        LOG.error((Object)("fail to execute batch-msg: " + this._message.getId() + ", sub-msg: " + subTask.getTaskId()), (Throwable)e);
                    }
                }
                result = new HelixTaskResult();
                result.setSuccess(isBatchTaskSucceed);
            }
            this._notificationContext.add(NotificationContext.MapKey.HELIX_TASK_RESULT.toString(), result);
            this.postHandleMessage();
            return result;
        }
    }

    @Override
    public void onError(Exception e, MessageHandler.ErrorCode code, MessageHandler.ErrorType type) {
        for (MessageHandler handler : this._subMessageHandlers) {
            handler.onError(e, code, type);
        }
    }

    private Map<PropertyKey, CurrentState> mergeCurStateUpdate(ConcurrentHashMap<String, CurrentStateUpdate> csUpdateMap) {
        HashMap<String, CurrentStateUpdate> curStateUpdateMap = new HashMap<String, CurrentStateUpdate>();
        for (CurrentStateUpdate update : csUpdateMap.values()) {
            String path = update._key.getPath();
            if (!curStateUpdateMap.containsKey(path)) {
                curStateUpdateMap.put(path, update);
                continue;
            }
            ((CurrentStateUpdate)curStateUpdateMap.get(path)).merge(update._delta);
        }
        HashMap<PropertyKey, CurrentState> ret = new HashMap<PropertyKey, CurrentState>();
        for (CurrentStateUpdate update : curStateUpdateMap.values()) {
            ret.put(update._key, update._delta);
        }
        return ret;
    }
}

