/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.handler.codec.spdy.DefaultSpdyHeaderBlock;
import io.netty.handler.codec.spdy.SpdySynReplyFrame;
import io.netty.util.internal.StringUtil;

public class DefaultSpdySynReplyFrame
extends DefaultSpdyHeaderBlock
implements SpdySynReplyFrame {
    private int streamID;
    private boolean last;

    public DefaultSpdySynReplyFrame(int streamID) {
        this.setStreamID(streamID);
    }

    @Override
    public int getStreamID() {
        return this.streamID;
    }

    @Override
    public void setStreamID(int streamID) {
        if (streamID <= 0) {
            throw new IllegalArgumentException("Stream-ID must be positive: " + streamID);
        }
        this.streamID = streamID;
    }

    @Override
    public boolean isLast() {
        return this.last;
    }

    @Override
    public void setLast(boolean last) {
        this.last = last;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append("(last: ");
        buf.append(this.isLast());
        buf.append(')');
        buf.append(StringUtil.NEWLINE);
        buf.append("--> Stream-ID = ");
        buf.append(this.streamID);
        buf.append(StringUtil.NEWLINE);
        buf.append("--> Headers:");
        buf.append(StringUtil.NEWLINE);
        this.appendHeaders(buf);
        buf.setLength(buf.length() - StringUtil.NEWLINE.length());
        return buf.toString();
    }
}

