/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.Component;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedResourceEndpointMBean;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.impl.ProcessorEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ResourceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Managed ResourceEndpoint")
public abstract class ResourceEndpoint
extends ProcessorEndpoint
implements ManagedResourceEndpointMBean {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private volatile byte[] buffer;
    private String resourceUri;
    @UriParam
    private boolean contentCache;

    public ResourceEndpoint() {
    }

    public ResourceEndpoint(String endpointUri, Component component, String resourceUri) {
        super(endpointUri, component);
        this.resourceUri = resourceUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getResourceAsInputStream() throws IOException {
        if (this.isContentCache()) {
            ResourceEndpoint resourceEndpoint = this;
            synchronized (resourceEndpoint) {
                if (this.buffer == null) {
                    this.log.debug("Reading resource: {} into the content cache", (Object)this.resourceUri);
                    InputStream is = this.getResourceAsInputStreamWithoutCache();
                    this.buffer = IOConverter.toBytes(is);
                    IOHelper.close((Closeable)is, this.resourceUri, this.log);
                }
            }
            this.log.debug("Using resource: {} from the content cache", (Object)this.resourceUri);
            return new ByteArrayInputStream(this.buffer);
        }
        return this.getResourceAsInputStreamWithoutCache();
    }

    protected InputStream getResourceAsInputStreamWithoutCache() throws IOException {
        return this.loadResource(this.resourceUri);
    }

    protected InputStream loadResource(String uri) throws IOException {
        return ResourceHelper.resolveMandatoryResourceAsInputStream(this.getCamelContext().getClassResolver(), uri);
    }

    @Override
    @ManagedAttribute(description="Whether the resource is cached")
    public boolean isContentCache() {
        return this.contentCache;
    }

    @Override
    @ManagedOperation(description="Clears the cached resource, forcing to re-load the resource on next request")
    public void clearContentCache() {
        this.log.debug("Clearing resource: {} from the content cache", (Object)this.resourceUri);
        this.buffer = null;
    }

    public boolean isContentCacheCleared() {
        return this.buffer == null;
    }

    @Override
    public void setContentCache(boolean contentCache) {
        this.contentCache = contentCache;
    }

    public String getResourceUri() {
        return this.resourceUri;
    }

    public void setResourceUri(String resourceUri) {
        this.resourceUri = resourceUri;
    }
}

