/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.security.Principal;
import org.restlet.Response;
import org.restlet.data.ChallengeMessage;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.engine.security.AuthenticatorUtils;
import org.restlet.engine.util.SystemUtils;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChallengeResponse
extends ChallengeMessage {
    private volatile String clientNonce;
    private volatile Reference digestRef;
    private volatile String identifier;
    private volatile String quality;
    private volatile char[] secret;
    private volatile String secretAlgorithm;
    private volatile int serverNounceCount;
    private volatile long timeIssued;

    public ChallengeResponse(ChallengeRequest challengeRequest, Response response, String identifier, char[] secret) {
        this(challengeRequest, response, identifier, secret, "NONE");
    }

    public ChallengeResponse(ChallengeRequest challengeRequest, Response response, String identifier, char[] secret, String secretAlgorithm) {
        this(challengeRequest.getScheme(), null, identifier, secret, secretAlgorithm, null, null, null, null, null, null, null, 0, 0L);
        AuthenticatorUtils.update(this, response.getRequest(), response);
    }

    public ChallengeResponse(ChallengeRequest challengeRequest, Response response, String identifier, String secret) {
        this(challengeRequest, response, identifier, secret.toCharArray(), "NONE");
    }

    public ChallengeResponse(ChallengeScheme scheme) {
        this(scheme, null, (char[])null);
    }

    public ChallengeResponse(ChallengeScheme scheme, Series<Parameter> parameters, String identifier, char[] secret, String secretAlgorithm, String realm, String quality, Reference digestRef, String digestAlgorithm, String opaque, String clientNonce, String serverNonce, int serverNounceCount, long timeIssued) {
        super(scheme, realm, parameters, digestAlgorithm, opaque, serverNonce);
        this.clientNonce = clientNonce;
        this.digestRef = digestRef;
        this.identifier = identifier;
        this.quality = quality;
        this.secret = secret;
        this.secretAlgorithm = secretAlgorithm;
        this.serverNounceCount = serverNounceCount;
        this.timeIssued = timeIssued;
    }

    public ChallengeResponse(ChallengeScheme scheme, String identifier, char[] secret) {
        this(scheme, identifier, secret, null);
    }

    public ChallengeResponse(ChallengeScheme scheme, String identifier, char[] secret, Series<Parameter> parameters) {
        this(scheme, parameters, identifier, secret, "NONE", null, null, null, null, null, null, null, 0, 0L);
    }

    public ChallengeResponse(ChallengeScheme scheme, String identifier, Series<Parameter> parameters) {
        this(scheme, identifier, null, parameters);
    }

    public ChallengeResponse(ChallengeScheme scheme, String identifier, String secret) {
        this(scheme, identifier, secret != null ? secret.toCharArray() : null);
    }

    public boolean equals(Object obj) {
        boolean result;
        boolean bl = result = obj == this;
        if (!result && obj instanceof ChallengeResponse) {
            ChallengeResponse that = (ChallengeResponse)obj;
            if (this.getRawValue() != null) {
                result = this.getRawValue().equals(that.getRawValue());
            } else {
                boolean bl2 = result = that.getRawValue() == null;
            }
            if (result) {
                if (this.getIdentifier() != null) {
                    result = this.getIdentifier().equals(that.getIdentifier());
                } else {
                    boolean bl3 = result = that.getIdentifier() == null;
                }
                if (result) {
                    if (this.getScheme() != null) {
                        result = this.getScheme().equals(that.getScheme());
                    } else {
                        boolean bl4 = result = that.getScheme() == null;
                    }
                    if (result) {
                        if (this.getSecret() == null || that.getSecret() == null) {
                            result = this.getSecret() == that.getSecret();
                        } else if (this.getSecret().length == that.getSecret().length) {
                            boolean equals = true;
                            for (int i = 0; i < this.getSecret().length && equals; ++i) {
                                equals = this.getSecret()[i] == that.getSecret()[i];
                            }
                            result = equals;
                        }
                    }
                }
            }
        }
        return result;
    }

    public String getClientNonce() {
        return this.clientNonce;
    }

    public Reference getDigestRef() {
        return this.digestRef;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Principal getPrincipal() {
        return new Principal(){

            public String getName() {
                return ChallengeResponse.this.getIdentifier();
            }
        };
    }

    public String getQuality() {
        return this.quality;
    }

    public char[] getSecret() {
        return this.secret;
    }

    public String getSecretAlgorithm() {
        return this.secretAlgorithm;
    }

    public int getServerNounceCount() {
        return this.serverNounceCount;
    }

    public String getServerNounceCountAsHex() {
        return AuthenticatorUtils.formatNonceCount(this.getServerNounceCount());
    }

    public long getTimeIssued() {
        return this.timeIssued;
    }

    @Override
    public int hashCode() {
        return SystemUtils.hashCode(this.getScheme(), this.getIdentifier(), this.getRawValue());
    }

    public void setClientNonce(String clientNonce) {
        this.clientNonce = clientNonce;
    }

    public void setDigestRef(Reference digestRef) {
        this.digestRef = digestRef;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setQuality(String quality) {
        this.quality = quality;
    }

    public void setSecret(char[] secret) {
        this.secret = secret;
    }

    public void setSecret(String secret) {
        this.secret = secret == null ? null : secret.toCharArray();
    }

    public void setSecretAlgorithm(String secretDigestAlgorithm) {
        this.secretAlgorithm = secretDigestAlgorithm;
    }

    public void setServerNounceCount(int serverNounceCount) {
        this.serverNounceCount = serverNounceCount;
    }

    public void setTimeIssued(long timeIssued) {
        this.timeIssued = timeIssued;
    }
}

