/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.PropertyKey;
import org.apache.helix.model.AlertStatus;
import org.apache.helix.model.Alerts;
import org.apache.helix.model.HealthStat;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.PersistentStats;

public class HealthDataCache {
    Map<String, LiveInstance> _liveInstanceMap;
    Map<String, Map<String, HealthStat>> _healthStatMap;
    HealthStat _globalStats;
    PersistentStats _persistentStats;
    Alerts _alerts;
    AlertStatus _alertStatus;

    public HealthStat getGlobalStats() {
        return this._globalStats;
    }

    public PersistentStats getPersistentStats() {
        return this._persistentStats;
    }

    public Alerts getAlerts() {
        return this._alerts;
    }

    public AlertStatus getAlertStatus() {
        return this._alertStatus;
    }

    public Map<String, HealthStat> getHealthStats(String instanceName) {
        Map<String, HealthStat> map = this._healthStatMap.get(instanceName);
        if (map != null) {
            return map;
        }
        return Collections.emptyMap();
    }

    public Map<String, LiveInstance> getLiveInstances() {
        return this._liveInstanceMap;
    }

    public boolean refresh(HelixDataAccessor accessor) {
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        this._liveInstanceMap = accessor.getChildValuesMap(keyBuilder.liveInstances());
        HashMap hsMap = new HashMap();
        for (String instanceName : this._liveInstanceMap.keySet()) {
            Map childValuesMap = accessor.getChildValuesMap(keyBuilder.healthReports(instanceName));
            hsMap.put(instanceName, childValuesMap);
        }
        this._healthStatMap = Collections.unmodifiableMap(hsMap);
        this._persistentStats = (PersistentStats)accessor.getProperty(keyBuilder.persistantStat());
        this._alerts = (Alerts)accessor.getProperty(keyBuilder.alerts());
        this._alertStatus = (AlertStatus)accessor.getProperty(keyBuilder.alertStatus());
        return true;
    }
}

