/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.sctp.codec;

import io.netty.buffer.ChannelBuffer;
import io.netty.buffer.ChannelBuffers;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.sctp.SctpChannel;
import io.netty.channel.sctp.SctpFrame;
import io.netty.channel.sctp.codec.DefaultInboundStreamFilter;
import io.netty.channel.sctp.codec.InboundStreamFilter;
import io.netty.handler.codec.oneone.OneToOneDecoder;

public class SctpFrameDecoder
extends OneToOneDecoder {
    private final InboundStreamFilter inboundStreamFilter;
    private volatile ChannelBuffer cumulation;

    public SctpFrameDecoder() {
        this.inboundStreamFilter = new DefaultInboundStreamFilter();
    }

    public SctpFrameDecoder(InboundStreamFilter inboundStreamFilter) {
        this.inboundStreamFilter = inboundStreamFilter;
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (!(msg instanceof SctpFrame)) {
            return msg;
        }
        SctpChannel sctpChannel = (SctpChannel)channel;
        SctpFrame sctpFrame = (SctpFrame)msg;
        if (this.inboundStreamFilter.filter(sctpChannel, sctpFrame)) {
            boolean complete = sctpFrame.getMessageInfo().isComplete();
            if (complete) {
                if (this.cumulation == null) {
                    return sctpFrame.getPayloadBuffer();
                }
                ChannelBuffer extractedFrame = ChannelBuffers.wrappedBuffer(this.cumulation, sctpFrame.getPayloadBuffer());
                this.cumulation = null;
                return extractedFrame;
            }
            this.cumulation = this.cumulation == null ? sctpFrame.getPayloadBuffer() : ChannelBuffers.wrappedBuffer(this.cumulation, sctpFrame.getPayloadBuffer());
            return null;
        }
        return msg;
    }
}

