/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server;

import com.thoughtworks.xstream.XStream;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.backend.server.UserServicesImpl;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.workbench.model.PerspectiveDefinition;
import org.uberfire.workbench.model.SplashScreenFilter;
import org.uberfire.workbench.services.WorkbenchServices;

@Service
@ApplicationScoped
public class WorkbenchServicesImpl
implements WorkbenchServices {
    @Inject
    @Named(value="configIO")
    private IOService ioService;
    @Inject
    private UserServicesImpl userServices;
    private XStream xs = new XStream();

    public void save(PerspectiveDefinition perspective) {
        if (!perspective.isTransient()) {
            String xml = this.xs.toXML((Object)perspective);
            Path perspectivePath = this.userServices.buildPath("perspectives", perspective.getName() + ".perspective");
            this.ioService.write(perspectivePath, xml, new OpenOption[0]);
        }
    }

    public void save(SplashScreenFilter splashFilter) {
        String xml = this.xs.toXML((Object)splashFilter);
        Path splashFilterPath = this.userServices.buildPath("splash", splashFilter.getName() + ".filter");
        this.ioService.write(splashFilterPath, xml, new OpenOption[0]);
    }

    public PerspectiveDefinition loadPerspective(String perspectiveName) {
        Path perspectivePath = this.userServices.buildPath("perspectives", perspectiveName + ".perspective");
        if (this.ioService.exists(perspectivePath)) {
            String xml = this.ioService.readAllString(perspectivePath);
            return (PerspectiveDefinition)this.xs.fromXML(xml);
        }
        return null;
    }

    public SplashScreenFilter loadSplashScreenFilter(String filterName) {
        Path splashFilterPath = this.userServices.buildPath("splash", filterName + ".filter");
        if (this.ioService.exists(splashFilterPath)) {
            String xml = this.ioService.readAllString(splashFilterPath);
            return (SplashScreenFilter)this.xs.fromXML(xml);
        }
        return null;
    }

    public Map<String, String> loadDefaultEditorsMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            Path path = this.getPathToDefaultEditors();
            if (this.ioService.exists(path)) {
                for (String line : this.ioService.readAllLines(path)) {
                    if (line.trim().startsWith("#")) continue;
                    String[] split = line.split("=");
                    map.put(split[0], split[1]);
                }
            }
            return map;
        }
        catch (NoSuchFileException e) {
            e.printStackTrace();
            return map;
        }
    }

    public void saveDefaultEditors(Map<String, String> properties) {
        StringBuilder text = new StringBuilder();
        for (String key : properties.keySet()) {
            text.append(String.format("%s=%s", key, properties.get(key)));
        }
        this.ioService.write(this.getPathToDefaultEditors(), text.toString(), new OpenOption[0]);
    }

    private Path getPathToDefaultEditors() {
        return this.userServices.buildPath("defaultEditors", null);
    }
}

