/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vm;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.component.seda.QueueReference;
import org.apache.camel.component.seda.SedaComponent;

public class VmComponent
extends SedaComponent {
    protected static final Map<String, QueueReference> QUEUES = new HashMap<String, QueueReference>();
    private static final AtomicInteger START_COUNTER = new AtomicInteger();

    @Override
    public Map<String, QueueReference> getQueues() {
        return QUEUES;
    }

    @Override
    public QueueReference getQueueReference(String key) {
        return QUEUES.get(key);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        START_COUNTER.incrementAndGet();
    }

    @Override
    protected void doStop() throws Exception {
        if (START_COUNTER.decrementAndGet() <= 0) {
            this.getQueues().clear();
        }
    }
}

