/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.logging;

import io.netty.buffer.ChannelBuffer;
import io.netty.buffer.ChannelBuffers;
import io.netty.channel.ChannelDownstreamHandler;
import io.netty.channel.ChannelEvent;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelUpstreamHandler;
import io.netty.channel.ExceptionEvent;
import io.netty.channel.MessageEvent;
import io.netty.logging.InternalLogLevel;
import io.netty.logging.InternalLogger;
import io.netty.logging.InternalLoggerFactory;

@ChannelHandler.Sharable
public class LoggingHandler
implements ChannelUpstreamHandler,
ChannelDownstreamHandler {
    private static final InternalLogLevel DEFAULT_LEVEL = InternalLogLevel.DEBUG;
    private final InternalLogger logger;
    private final InternalLogLevel level;
    private final boolean hexDump;

    public LoggingHandler() {
        this(true);
    }

    public LoggingHandler(InternalLogLevel level) {
        this(level, true);
    }

    public LoggingHandler(boolean hexDump) {
        this(DEFAULT_LEVEL, hexDump);
    }

    public LoggingHandler(InternalLogLevel level, boolean hexDump) {
        if (level == null) {
            throw new NullPointerException("level");
        }
        this.logger = InternalLoggerFactory.getInstance(this.getClass());
        this.level = level;
        this.hexDump = hexDump;
    }

    public LoggingHandler(Class<?> clazz) {
        this(clazz, true);
    }

    public LoggingHandler(Class<?> clazz, boolean hexDump) {
        this(clazz, DEFAULT_LEVEL, hexDump);
    }

    public LoggingHandler(Class<?> clazz, InternalLogLevel level) {
        this(clazz, level, true);
    }

    public LoggingHandler(Class<?> clazz, InternalLogLevel level, boolean hexDump) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        if (level == null) {
            throw new NullPointerException("level");
        }
        this.logger = InternalLoggerFactory.getInstance(clazz);
        this.level = level;
        this.hexDump = hexDump;
    }

    public LoggingHandler(String name) {
        this(name, true);
    }

    public LoggingHandler(String name, boolean hexDump) {
        this(name, DEFAULT_LEVEL, hexDump);
    }

    public LoggingHandler(String name, InternalLogLevel level, boolean hexDump) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (level == null) {
            throw new NullPointerException("level");
        }
        this.logger = InternalLoggerFactory.getInstance(name);
        this.level = level;
        this.hexDump = hexDump;
    }

    public InternalLogger getLogger() {
        return this.logger;
    }

    public InternalLogLevel getLevel() {
        return this.level;
    }

    public void log(ChannelEvent e) {
        if (this.getLogger().isEnabled(this.level)) {
            MessageEvent me;
            String msg = e.toString();
            if (this.hexDump && e instanceof MessageEvent && (me = (MessageEvent)e).getMessage() instanceof ChannelBuffer) {
                ChannelBuffer buf = (ChannelBuffer)me.getMessage();
                msg = msg + " - (HEXDUMP: " + ChannelBuffers.hexDump(buf) + ')';
            }
            if (e instanceof ExceptionEvent) {
                this.getLogger().log(this.level, msg, ((ExceptionEvent)e).getCause());
            } else {
                this.getLogger().log(this.level, msg);
            }
        }
    }

    @Override
    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        this.log(e);
        ctx.sendUpstream(e);
    }

    @Override
    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        this.log(e);
        ctx.sendDownstream(e);
    }
}

