/*
 * Copyright 2011 JBoss, by Red Hat, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.errai.common.client.api.interceptor;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * This annotation is used to indicate that a particular class should be 
 * used as an interceptor for a remote interface (e.g. RPC or REST 
 * interface).  This works similarly to the {@link InterceptedCall}
 * annotation but has the added benefit that it does not require the
 * remote interface to be annotated.
 * 
 * The class that is annotated should implement the {@link RemoteCallInterceptor}
 * interface.
 */
@Documented
@Target({ ElementType.TYPE })
@Retention(RetentionPolicy.RUNTIME)
public @interface InterceptsRemoteCall {

  /**
   * The interceptor type(s) to use. Interceptor execution is guaranteed to be
   * in declaration order.
   */
  Class<?>[] value();
}