/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.engines.htmlextractor.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class DOMUtils {
    public static void printDOM(Node node, PrintStream out) {
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                out.println("<?xml version=\"1.0\" ?>");
                DOMUtils.printDOM(((Document)node).getDocumentElement(), out);
                break;
            }
            case 1: {
                out.print("<");
                out.print(node.getNodeName());
                NamedNodeMap attrs = node.getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node attr = attrs.item(i);
                    out.print(" " + attr.getNodeName().trim() + "=\"" + DOMUtils.quoteXMLChars(attr.getNodeValue().trim()) + "\"");
                }
                out.println(">");
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int len = children.getLength();
                for (int i = 0; i < len; ++i) {
                    DOMUtils.printDOM(children.item(i), out);
                }
                break;
            }
            case 5: {
                out.print("&");
                out.print(node.getNodeName().trim());
                out.print(";");
                break;
            }
            case 4: {
                out.print("<![CDATA[");
                out.print(node.getNodeValue().trim());
                out.print("]]>");
                break;
            }
            case 3: {
                out.print(DOMUtils.quoteXMLChars(node.getNodeValue().trim()));
                break;
            }
            case 7: {
                out.print("<?");
                out.print(node.getNodeName().trim());
                String data = node.getNodeValue().trim();
                out.print(" ");
                out.print(data);
                out.print("?>");
                break;
            }
            default: {
                System.err.println("unknown type " + type);
            }
        }
        if (type == 1) {
            out.println();
            out.print("</");
            out.print(node.getNodeName().trim());
            out.println('>');
        }
    }

    public static void printXML(Document doc) {
        try {
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(System.out);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.setOutputProperty("indent", "yes");
            xformer.setOutputProperty("encoding", "UTF-8");
            xformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            xformer.setOutputProperty("method", "xml");
            xformer.transform(source, result);
        }
        catch (TransformerConfigurationException tce) {
            System.err.println(tce.getMessage());
            Throwable x = tce;
            if (tce.getException() != null) {
                x = tce.getException();
            }
            ((Throwable)x).printStackTrace();
        }
        catch (TransformerException te) {
            System.err.println(te.getMessage());
            Throwable x = te;
            if (te.getException() != null) {
                x = te.getException();
            }
            ((Throwable)x).printStackTrace();
        }
    }

    public static String getStringFromDoc(Document doc, String encoding, String docTypeDef) {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer xformer = tFactory.newTransformer();
            xformer.setOutputProperty("indent", "yes");
            xformer.setOutputProperty("encoding", encoding);
            xformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            xformer.setOutputProperty("method", "xml");
            if (null != docTypeDef) {
                xformer.setOutputProperty("doctype-system", docTypeDef);
            }
            DOMSource source = new DOMSource(doc);
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            xformer.transform(source, result);
            return sw.toString();
        }
        catch (TransformerConfigurationException tce) {
            System.err.println("** Transformer Factory error");
            System.err.println("   " + tce.getMessage());
            Throwable x = tce;
            if (tce.getException() != null) {
                x = tce.getException();
            }
            ((Throwable)x).printStackTrace();
        }
        catch (TransformerException te) {
            System.err.println("** Transformation error");
            System.err.println("   " + te.getMessage());
            Throwable x = te;
            if (te.getException() != null) {
                x = te.getException();
            }
            ((Throwable)x).printStackTrace();
        }
        return null;
    }

    public static void writeXml(Document doc, String encoding, String docTypeDef, OutputStream out) {
        try {
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(out);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.setOutputProperty("indent", "yes");
            xformer.setOutputProperty("encoding", encoding);
            xformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            xformer.setOutputProperty("method", "xml");
            if (null != docTypeDef) {
                xformer.setOutputProperty("doctype-system", docTypeDef);
            }
            xformer.transform(source, result);
        }
        catch (TransformerConfigurationException tce) {
            System.err.println(tce.getMessage());
            Throwable x = tce;
            if (tce.getException() != null) {
                x = tce.getException();
            }
            ((Throwable)x).printStackTrace();
        }
        catch (TransformerException te) {
            System.err.println(te.getMessage());
            Throwable x = te;
            if (te.getException() != null) {
                x = te.getException();
            }
            ((Throwable)x).printStackTrace();
        }
    }

    public static Document parse(String xml, String encoding) {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        factory.setIgnoringElementContentWhitespace(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(new ByteArrayInputStream(xml.getBytes(encoding)));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return document;
    }

    public static Document parse(String fileName, boolean validation) {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(validation);
        factory.setNamespaceAware(true);
        factory.setIgnoringElementContentWhitespace(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(new File(fileName));
            return document;
        }
        catch (SAXParseException spe) {
            System.err.println("Parsing error, line " + spe.getLineNumber() + ", uri " + spe.getSystemId());
            System.err.println(" " + spe.getMessage());
            Exception x = spe;
            if (spe.getException() != null) {
                x = spe.getException();
            }
            x.printStackTrace();
        }
        catch (SAXException sxe) {
            System.err.println(sxe.getMessage());
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            x.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            System.err.println(pce.getMessage());
            pce.printStackTrace();
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
            ioe.printStackTrace();
        }
        return null;
    }

    public static int countByTagName(String tag, Document doc) {
        NodeList list = doc.getElementsByTagName(tag);
        return list.getLength();
    }

    public static int indexOf(NodeList list, Node node) {
        int j = list.getLength();
        for (int i = 0; i < j; ++i) {
            if (list.item(i) != node) continue;
            return i;
        }
        return -1;
    }

    public static String getText(Node node) {
        short nodeType = node.getNodeType();
        if (nodeType == 3 || nodeType == 2 || nodeType == 4) {
            return node.getNodeValue();
        }
        if (nodeType == 1) {
            NodeList dtrs = node.getChildNodes();
            StringBuffer sb = new StringBuffer();
            int j = dtrs.getLength();
            for (int i = 0; i < j; ++i) {
                Node item = dtrs.item(i);
                if (item.getNodeType() != 3 && item.getNodeType() != 4) continue;
                sb.append(item.getNodeValue());
            }
            return sb.toString();
        }
        return null;
    }

    public static List<Node> getChildren(Element ele, String name) {
        NodeList dtrs = ele.getChildNodes();
        ArrayList<Node> eles = new ArrayList<Node>();
        int j = dtrs.getLength();
        for (int i = 0; i < j; ++i) {
            Node item = dtrs.item(i);
            if (name != null && !item.getNodeName().equals(name)) continue;
            eles.add(item);
        }
        return eles;
    }

    public static List<Element> getChildrenElements(Element ele) {
        NodeList dtrs = ele.getChildNodes();
        ArrayList<Element> eles = new ArrayList<Element>();
        int j = dtrs.getLength();
        for (int i = 0; i < j; ++i) {
            Node item = dtrs.item(i);
            if (item.getNodeType() != 1) continue;
            eles.add((Element)item);
        }
        return eles;
    }

    public static Element getFirstChild(Element ele, String name) {
        NodeList dtrs = ele.getChildNodes();
        int iMax = dtrs.getLength();
        for (int i = 0; i < iMax; ++i) {
            Node item = dtrs.item(i);
            if (!item.getNodeName().equals(name)) continue;
            return (Element)item;
        }
        return null;
    }

    public static Element addChild(Element ele, String name) {
        Element child = ele.getOwnerDocument().createElement(name);
        ele.appendChild(child);
        return child;
    }

    public static String quoteXMLChars(String text) {
        if (text != null) {
            return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;");
        }
        return text;
    }
}

