/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.util.FindAnnotation;

public class PickConstructor {
    private static final Logger logger = Logger.getLogger(PickConstructor.class);

    public static Constructor pickSingletonConstructor(Class clazz) {
        Constructor<?>[] constructors = clazz.getConstructors();
        Object constructor = null;
        int numParameters = 0;
        Constructor<?> pick = null;
        boolean potentialConflict = false;
        for (Constructor<?> con : constructors) {
            if (!Modifier.isPublic(con.getModifiers()) || con.getParameterTypes().length < numParameters) continue;
            if (con.getParameterTypes().length > numParameters) {
                potentialConflict = false;
            }
            boolean noContextAnnotation = false;
            if (con.getParameterAnnotations() != null) {
                for (Annotation[] ann : con.getParameterAnnotations()) {
                    if (FindAnnotation.findAnnotation(ann, Context.class) != null) continue;
                    noContextAnnotation = true;
                }
            }
            if (noContextAnnotation) continue;
            if (con.getParameterTypes().length == numParameters && numParameters != 0) {
                potentialConflict = true;
            }
            numParameters = con.getParameterTypes().length;
            pick = con;
        }
        if (potentialConflict) {
            logger.warn("Ambiguity constructors are found in " + clazz + ". More details please refer to http://jsr311.java.net/nonav/releases/1.1/spec/spec.html");
        }
        return pick;
    }

    public static Constructor pickPerRequestConstructor(Class clazz) {
        Constructor<?>[] constructors = clazz.getConstructors();
        Object constructor = null;
        int numParameters = 0;
        Constructor<?> pick = null;
        boolean potentialConflict = false;
        for (Constructor<?> con : constructors) {
            if (!Modifier.isPublic(con.getModifiers()) || con.getParameterTypes().length < numParameters) continue;
            if (con.getParameterTypes().length > numParameters) {
                potentialConflict = false;
            }
            boolean noContextAnnotation = false;
            if (con.getParameterAnnotations() != null) {
                for (Annotation[] ann : con.getParameterAnnotations()) {
                    if (FindAnnotation.findJaxRSAnnotations(ann).length != 0) continue;
                    noContextAnnotation = true;
                }
            }
            if (noContextAnnotation) continue;
            if (con.getParameterTypes().length == numParameters && numParameters != 0) {
                potentialConflict = true;
            }
            numParameters = con.getParameterTypes().length;
            pick = con;
        }
        if (potentialConflict) {
            logger.warn("Ambiguity constructors are found in " + clazz + ". More details please refer to http://jsr311.java.net/nonav/releases/1.1/spec/spec.html");
        }
        return pick;
    }
}

