/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.impl;

import java.util.Locale;
import java.util.ResourceBundle;
import org.ocpsoft.prettytime.Duration;
import org.ocpsoft.prettytime.LocaleAware;
import org.ocpsoft.prettytime.TimeFormat;
import org.ocpsoft.prettytime.format.SimpleTimeFormat;
import org.ocpsoft.prettytime.impl.ResourcesTimeUnit;
import org.ocpsoft.prettytime.impl.TimeFormatProvider;

public class ResourcesTimeFormat
extends SimpleTimeFormat
implements TimeFormat,
LocaleAware<ResourcesTimeFormat> {
    private ResourceBundle bundle;
    private final ResourcesTimeUnit unit;
    private TimeFormat override;

    public ResourcesTimeFormat(ResourcesTimeUnit unit) {
        this.unit = unit;
    }

    @Override
    public ResourcesTimeFormat setLocale(Locale locale) {
        this.bundle = ResourceBundle.getBundle(this.unit.getResourceBundleName(), locale);
        if (this.bundle instanceof TimeFormatProvider) {
            TimeFormat format = ((TimeFormatProvider)((Object)this.bundle)).getFormatFor(this.unit);
            if (format != null) {
                this.override = format;
            }
        } else {
            this.override = null;
        }
        if (this.override == null) {
            this.setPattern(this.bundle.getString(this.unit.getResourceKeyPrefix() + "Pattern"));
            this.setFuturePrefix(this.bundle.getString(this.unit.getResourceKeyPrefix() + "FuturePrefix"));
            this.setFutureSuffix(this.bundle.getString(this.unit.getResourceKeyPrefix() + "FutureSuffix"));
            this.setPastPrefix(this.bundle.getString(this.unit.getResourceKeyPrefix() + "PastPrefix"));
            this.setPastSuffix(this.bundle.getString(this.unit.getResourceKeyPrefix() + "PastSuffix"));
            this.setSingularName(this.bundle.getString(this.unit.getResourceKeyPrefix() + "SingularName"));
            this.setPluralName(this.bundle.getString(this.unit.getResourceKeyPrefix() + "PluralName"));
            try {
                this.setFuturePluralName(this.bundle.getString(this.unit.getResourceKeyPrefix() + "FuturePluralName"));
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.setFutureSingularName(this.bundle.getString(this.unit.getResourceKeyPrefix() + "FutureSingularName"));
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.setPastPluralName(this.bundle.getString(this.unit.getResourceKeyPrefix() + "PastPluralName"));
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.setPastSingularName(this.bundle.getString(this.unit.getResourceKeyPrefix() + "PastSingularName"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this;
    }

    @Override
    public String decorate(Duration duration, String time) {
        return this.override == null ? super.decorate(duration, time) : this.override.decorate(duration, time);
    }

    @Override
    public String decorateUnrounded(Duration duration, String time) {
        return this.override == null ? super.decorateUnrounded(duration, time) : this.override.decorateUnrounded(duration, time);
    }

    @Override
    public String format(Duration duration) {
        return this.override == null ? super.format(duration) : this.override.format(duration);
    }

    @Override
    public String formatUnrounded(Duration duration) {
        return this.override == null ? super.formatUnrounded(duration) : this.override.formatUnrounded(duration);
    }
}

