/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.authentication.web;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.picketlink.Identity;
import org.picketlink.annotations.PicketLink;
import org.picketlink.authentication.web.BasicAuthenticationScheme;
import org.picketlink.authentication.web.ClientCertAuthenticationScheme;
import org.picketlink.authentication.web.DigestAuthenticationScheme;
import org.picketlink.authentication.web.FormAuthenticationScheme;
import org.picketlink.authentication.web.HTTPAuthenticationScheme;
import org.picketlink.common.util.StringUtil;
import org.picketlink.credential.DefaultLoginCredentials;

@ApplicationScoped
public class AuthenticationFilter
implements Filter {
    public static final String AUTH_TYPE_INIT_PARAM = "authType";
    public static final String UNPROTECTED_METHODS_INIT_PARAM = "unprotectedMethods";
    public static final String FORCE_REAUTHENTICATION_INIT_PARAM = "forceReAuthentication";
    public static final String STATELESS_AUTHENTICATION_INIT_PARAM = "statelessAuthentication";
    private final Set<String> unprotectedMethods = new HashSet<String>();
    private boolean forceReAuthentication;
    private boolean statelessAuthentication;
    @Inject
    private Instance<Identity> identityInstance;
    @Inject
    @Identity.Stateless
    private Instance<Identity> statelessIdentityInstance;
    @Inject
    private Instance<DefaultLoginCredentials> credentialsInstance;
    @Inject
    @Any
    private Instance<HTTPAuthenticationScheme> allAvailableAuthSchemesInstance;
    @Inject
    @PicketLink
    private Instance<HTTPAuthenticationScheme> applicationPreferredAuthSchemeInstance;
    private HTTPAuthenticationScheme authenticationScheme;

    public void init(FilterConfig config) throws ServletException {
        String forceReAuthentication;
        this.authenticationScheme = this.resolveAuthenticationScheme(config);
        this.authenticationScheme.initialize(config);
        String unprotectedMethodsInitParam = config.getInitParameter(UNPROTECTED_METHODS_INIT_PARAM);
        if (unprotectedMethodsInitParam != null) {
            if (unprotectedMethodsInitParam.contains(",")) {
                for (String method : unprotectedMethodsInitParam.split(",")) {
                    this.unprotectedMethods.add(method.trim().toUpperCase());
                }
            } else {
                this.unprotectedMethods.add(unprotectedMethodsInitParam.trim().toUpperCase());
            }
        }
        if (StringUtil.isNullOrEmpty((String)(forceReAuthentication = config.getInitParameter(FORCE_REAUTHENTICATION_INIT_PARAM)))) {
            forceReAuthentication = "false";
        }
        this.forceReAuthentication = Boolean.valueOf(forceReAuthentication);
        String statelessAuthentication = config.getInitParameter(STATELESS_AUTHENTICATION_INIT_PARAM);
        if (StringUtil.isNullOrEmpty((String)statelessAuthentication)) {
            statelessAuthentication = "false";
        }
        this.statelessAuthentication = Boolean.valueOf(statelessAuthentication);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        if (!HttpServletRequest.class.isInstance(servletRequest)) {
            throw new ServletException("This filter can only process HttpServletRequest requests.");
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        Identity identity = this.getIdentity();
        DefaultLoginCredentials creds = this.extractCredentials(request);
        if (creds.getCredential() != null && this.forceReAuthentication) {
            identity.logout();
            creds = this.extractCredentials(request);
        }
        if (this.isProtected(request) && !identity.isLoggedIn()) {
            if (!this.statelessAuthentication) {
                request.getSession(true);
            }
            if (creds.getCredential() != null) {
                identity.login();
            }
            if (identity.isLoggedIn()) {
                if (this.authenticationScheme.postAuthentication(request, response)) {
                    chain.doFilter(servletRequest, servletResponse);
                }
            } else {
                this.authenticationScheme.challengeClient(request, response);
            }
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void destroy() {
    }

    private HTTPAuthenticationScheme resolveAuthenticationScheme(FilterConfig config) {
        Class<? extends HTTPAuthenticationScheme> authTypeClass;
        if (this.applicationPreferredAuthSchemeInstance.isAmbiguous()) {
            String error = AuthenticationFilter.ambiguousBeanError(this.applicationPreferredAuthSchemeInstance, "There is more than one @PicketLink HTTPAuthenticationScheme. Make sure you have only one such type defined.");
            throw new IllegalStateException(error);
        }
        if (!this.applicationPreferredAuthSchemeInstance.isUnsatisfied()) {
            return (HTTPAuthenticationScheme)this.applicationPreferredAuthSchemeInstance.get();
        }
        String authTypeName = config.getInitParameter(AUTH_TYPE_INIT_PARAM);
        if (authTypeName == null) {
            throw new IllegalArgumentException("No HTTPAuthenticationScheme found. You must provide either a CDI bean qualified with @PicketLink, or define it by fully-qualified class name in the authType init parameter of the " + this.getClass().getName() + " filter in web.xml.");
        }
        try {
            authTypeClass = AuthType.valueOf(authTypeName.toUpperCase()).getSchemeType();
        }
        catch (IllegalArgumentException iae) {
            try {
                authTypeClass = Class.forName(authTypeName).asSubclass(HTTPAuthenticationScheme.class);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalStateException("HTTPAuthenticationScheme " + authTypeName + " from web.xml could not be found.", cnfe);
            }
        }
        Instance configuredAuthScheme = this.allAvailableAuthSchemesInstance.select(authTypeClass, new Annotation[0]);
        if (configuredAuthScheme.isAmbiguous()) {
            throw new IllegalStateException(AuthenticationFilter.ambiguousBeanError(configuredAuthScheme, "HTTPAuthenticationScheme type from web.xml is ambiguous."));
        }
        return (HTTPAuthenticationScheme)configuredAuthScheme.get();
    }

    private static String ambiguousBeanError(Instance<?> ambiguousInstance, String message) {
        StringBuilder sb = new StringBuilder(message);
        sb.append("\nAmbiguous types:");
        for (Object o : ambiguousInstance) {
            sb.append("\n  ").append(o.getClass().getName());
        }
        return sb.toString();
    }

    private DefaultLoginCredentials extractCredentials(HttpServletRequest request) {
        DefaultLoginCredentials creds = this.getCredentials();
        this.authenticationScheme.extractCredential(request, creds);
        return creds;
    }

    private DefaultLoginCredentials getCredentials() {
        if (this.credentialsInstance.isUnsatisfied()) {
            throw new IllegalStateException("DefaultLoginCredentials not found - please ensure that the DefaultLoginCredentials component is created on startup.");
        }
        if (this.credentialsInstance.isAmbiguous()) {
            throw new IllegalStateException("DefaultLoginCredentials is ambiguous. Make sure you have a single @RequestScoped instance.");
        }
        try {
            return (DefaultLoginCredentials)((Object)this.credentialsInstance.get());
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not retrieve credentials.", e);
        }
    }

    private Identity getIdentity() {
        if (this.statelessAuthentication) {
            return this.getIdentity(this.statelessIdentityInstance);
        }
        return this.getIdentity(this.identityInstance);
    }

    private Identity getIdentity(Instance<Identity> identityInstance) {
        if (identityInstance.isUnsatisfied()) {
            throw new IllegalStateException("Identity not found.");
        }
        if (identityInstance.isAmbiguous()) {
            throw new IllegalStateException("Identity is ambiguous.");
        }
        try {
            return (Identity)identityInstance.get();
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not retrieve Identity.", e);
        }
    }

    private boolean isProtected(HttpServletRequest request) {
        return !this.unprotectedMethods.contains(request.getMethod().toUpperCase()) && this.authenticationScheme.isProtected(request);
    }

    public static enum AuthType {
        BASIC(BasicAuthenticationScheme.class),
        DIGEST(DigestAuthenticationScheme.class),
        FORM(FormAuthenticationScheme.class),
        CLIENT_CERT(ClientCertAuthenticationScheme.class);

        private final Class<? extends HTTPAuthenticationScheme> schemeType;

        private AuthType(Class<? extends HTTPAuthenticationScheme> schemeType) {
            this.schemeType = schemeType;
        }

        public Class<? extends HTTPAuthenticationScheme> getSchemeType() {
            return this.schemeType;
        }
    }
}

