/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import org.apache.camel.Exchange;
import org.apache.camel.api.management.PerformanceCounter;

public class CompositePerformanceCounter
implements PerformanceCounter {
    private final PerformanceCounter counter1;
    private final PerformanceCounter counter2;

    public CompositePerformanceCounter(PerformanceCounter counter1, PerformanceCounter counter2) {
        this.counter1 = counter1;
        this.counter2 = counter2;
    }

    @Override
    public void completedExchange(Exchange exchange, long time) {
        if (this.counter1.isStatisticsEnabled()) {
            this.counter1.completedExchange(exchange, time);
        }
        if (this.counter2.isStatisticsEnabled()) {
            this.counter2.completedExchange(exchange, time);
        }
    }

    @Override
    public void failedExchange(Exchange exchange) {
        if (this.counter1.isStatisticsEnabled()) {
            this.counter1.failedExchange(exchange);
        }
        if (this.counter2.isStatisticsEnabled()) {
            this.counter2.failedExchange(exchange);
        }
    }

    @Override
    public boolean isStatisticsEnabled() {
        return true;
    }

    @Override
    public void setStatisticsEnabled(boolean statisticsEnabled) {
    }
}

