/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.restlet.Restlet;
import org.restlet.data.Parameter;
import org.restlet.engine.Engine;
import org.restlet.engine.util.ChildContext;
import org.restlet.security.Enroler;
import org.restlet.security.Verifier;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Context {
    private static final ThreadLocal<Context> CURRENT = new ThreadLocal();
    private volatile Restlet clientDispatcher;
    private volatile Restlet serverDispatcher;
    private final ConcurrentMap<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private volatile Logger logger;
    private final Series<Parameter> parameters;
    private volatile Enroler defaultEnroler;
    private volatile Verifier defaultVerifier;

    public static Context getCurrent() {
        return CURRENT.get();
    }

    public static Logger getCurrentLogger() {
        return Context.getCurrent() != null ? Context.getCurrent().getLogger() : Engine.getLogger("org.restlet");
    }

    public static void setCurrent(Context context) {
        CURRENT.set(context);
    }

    public Context() {
        this("org.restlet");
    }

    public Context(Logger logger) {
        this.logger = logger;
        this.parameters = new Series<Parameter>(Parameter.class, new CopyOnWriteArrayList());
        this.clientDispatcher = null;
        this.defaultEnroler = null;
        this.serverDispatcher = null;
        this.defaultVerifier = null;
    }

    public Context(String loggerName) {
        this(Engine.getLogger(loggerName));
    }

    public Context createChildContext() {
        return new ChildContext(this);
    }

    public ConcurrentMap<String, Object> getAttributes() {
        return this.attributes;
    }

    public Restlet getClientDispatcher() {
        return this.clientDispatcher;
    }

    public Enroler getDefaultEnroler() {
        return this.defaultEnroler;
    }

    public Verifier getDefaultVerifier() {
        return this.defaultVerifier;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Series<Parameter> getParameters() {
        return this.parameters;
    }

    public Restlet getServerDispatcher() {
        return this.serverDispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributes(Map<String, Object> attributes) {
        ConcurrentMap<String, Object> concurrentMap = this.getAttributes();
        synchronized (concurrentMap) {
            if (attributes != this.getAttributes()) {
                this.getAttributes().clear();
                if (attributes != null) {
                    this.getAttributes().putAll(attributes);
                }
            }
        }
    }

    public void setClientDispatcher(Restlet clientDispatcher) {
        this.clientDispatcher = clientDispatcher;
    }

    public void setDefaultEnroler(Enroler enroler) {
        this.defaultEnroler = enroler;
    }

    public void setDefaultVerifier(Verifier verifier) {
        this.defaultVerifier = verifier;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setLogger(String loggerName) {
        this.setLogger(Engine.getLogger(loggerName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameters(Series<Parameter> parameters) {
        Series<Parameter> series = this.getParameters();
        synchronized (series) {
            if (parameters != this.getParameters()) {
                this.getParameters().clear();
                if (parameters != null) {
                    this.getParameters().addAll(parameters);
                }
            }
        }
    }

    public void setServerDispatcher(Restlet serverDispatcher) {
        this.serverDispatcher = serverDispatcher;
    }
}

