/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.alerts;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.PropertyKey;
import org.apache.helix.alerts.Alert;
import org.apache.helix.alerts.AlertParser;
import org.apache.helix.alerts.AlertValueAndStatus;
import org.apache.helix.alerts.StatsHolder;
import org.apache.helix.alerts.Tuple;
import org.apache.helix.controller.stages.HealthDataCache;
import org.apache.helix.model.AlertStatus;
import org.apache.helix.model.Alerts;
import org.apache.log4j.Logger;

public class AlertsHolder {
    private static final Logger logger = Logger.getLogger((String)AlertsHolder.class.getName());
    HelixDataAccessor _accessor;
    HealthDataCache _cache;
    Map<String, Map<String, String>> _alertsMap;
    Map<String, Map<String, String>> _alertStatusMap;
    HashSet<String> alerts;
    StatsHolder _statsHolder;
    private final HelixManager _manager;
    private PropertyKey.Builder _keyBuilder;

    public AlertsHolder(HelixManager manager, HealthDataCache cache) {
        this(manager, cache, new StatsHolder(manager, cache));
    }

    public AlertsHolder(HelixManager manager, HealthDataCache cache, StatsHolder statHolder) {
        this._manager = manager;
        this._accessor = manager.getHelixDataAccessor();
        this._cache = cache;
        this._statsHolder = statHolder;
        this._keyBuilder = new PropertyKey.Builder(this._manager.getClusterName());
        this.updateCache(this._cache);
    }

    public void refreshAlerts() {
        this._cache.refresh(this._accessor);
        this.updateCache(this._cache);
    }

    public void refreshAlertStatus() {
        AlertStatus alertStatusRecord = this._cache.getAlertStatus();
        this._alertStatusMap = alertStatusRecord != null ? alertStatusRecord.getMapFields() : new HashMap<String, Map<String, String>>();
    }

    public void persistAlerts() {
        Alerts alerts = (Alerts)this._accessor.getProperty(this._keyBuilder.alerts());
        if (alerts == null) {
            alerts = new Alerts("Alerts");
        }
        alerts.getRecord().setMapFields(this._alertsMap);
        boolean retVal = this._accessor.setProperty(this._keyBuilder.alerts(), alerts);
        logger.debug((Object)("persistAlerts retVal: " + retVal));
    }

    public void persistAlertStatus() {
        AlertStatus alertStatus = (AlertStatus)this._accessor.getProperty(this._keyBuilder.alertStatus());
        if (alertStatus == null) {
            alertStatus = new AlertStatus("AlertStatus");
        }
        alertStatus.getRecord().setMapFields(this._alertStatusMap);
        boolean retVal = this._accessor.setProperty(this._keyBuilder.alertStatus(), alertStatus);
        logger.debug((Object)("persistAlerts retVal: " + retVal));
    }

    private void readExistingAlerts() {
    }

    public void addAlert(String alert) throws HelixException {
        alert = alert.replaceAll("\\s+", "");
        AlertParser.validateAlert(alert);
        this.refreshAlerts();
        HashMap<String, String> alertFields = new HashMap<String, String>();
        alertFields.put("EXP", AlertParser.getComponent("EXP", alert));
        alertFields.put("CMP", AlertParser.getComponent("CMP", alert));
        alertFields.put("CON", AlertParser.getComponent("CON", alert));
        try {
            alertFields.put("ACTION", AlertParser.getComponent("ACTION", alert));
        }
        catch (Exception e) {
            logger.info((Object)("No action specified in " + alert));
        }
        this._statsHolder.addStat((String)alertFields.get("EXP"));
        this._statsHolder.persistStats();
        this._alertsMap.put(alert, alertFields);
        this.persistAlerts();
    }

    public void addAlertStatusSet(Map<String, Map<String, AlertValueAndStatus>> statusSet) throws HelixException {
        if (this._alertStatusMap == null) {
            this._alertStatusMap = new HashMap<String, Map<String, String>>();
        }
        this._alertStatusMap.clear();
        for (String alert : statusSet.keySet()) {
            Map<String, AlertValueAndStatus> currStatus = statusSet.get(alert);
            if (currStatus == null) continue;
            this.addAlertStatus(alert, currStatus);
        }
        AlertStatus alertStatus = (AlertStatus)this._accessor.getProperty(this._keyBuilder.alertStatus());
        int alertStatusSize = 0;
        if (alertStatus != null) {
            alertStatusSize = alertStatus.getMapFields().size();
        }
        if (this._alertStatusMap.size() > 0 || alertStatusSize > 0) {
            this.persistAlertStatus();
        }
    }

    private void addAlertStatus(String parentAlertKey, Map<String, AlertValueAndStatus> alertStatus) throws HelixException {
        for (String alertName : alertStatus.keySet()) {
            String mapAlertKey = parentAlertKey;
            if (!alertName.equals("*")) {
                mapAlertKey = mapAlertKey + " : (" + alertName + ")";
            }
            AlertValueAndStatus vs = alertStatus.get(alertName);
            HashMap<String, String> alertFields = new HashMap<String, String>();
            alertFields.put("value", vs.getValue().toString());
            alertFields.put("fired", String.valueOf(vs.isFired()));
            this._alertStatusMap.put(mapAlertKey, alertFields);
        }
    }

    public AlertValueAndStatus getAlertValueAndStatus(String alertName) {
        Map<String, String> alertFields = this._alertStatusMap.get(alertName);
        String val = alertFields.get("value");
        Tuple<String> valTup = new Tuple<String>();
        valTup.add(val);
        boolean fired = Boolean.valueOf(alertFields.get("fired"));
        AlertValueAndStatus vs = new AlertValueAndStatus(valTup, fired);
        return vs;
    }

    public static void parseAlert(String alert, StringBuilder statsName, Map<String, String> alertFields) throws HelixException {
        alert = alert.replaceAll("\\s+", "");
        AlertParser.validateAlert(alert);
        alertFields.put("EXP", AlertParser.getComponent("EXP", alert));
        alertFields.put("CMP", AlertParser.getComponent("CMP", alert));
        alertFields.put("CON", AlertParser.getComponent("CON", alert));
        try {
            alertFields.put("ACTION", AlertParser.getComponent("ACTION", alert));
        }
        catch (Exception e) {
            logger.info((Object)("No action specified in " + alert));
        }
        statsName.append(alertFields.get("EXP"));
    }

    public List<Alert> getAlertList() {
        LinkedList<Alert> alerts = new LinkedList<Alert>();
        for (String alert : this._alertsMap.keySet()) {
            Map<String, String> alertFields = this._alertsMap.get(alert);
            String exp = alertFields.get("EXP");
            String comp = alertFields.get("CMP");
            Tuple<String> con = Tuple.fromString(alertFields.get("CON"));
            Alert a = new Alert(alert, exp, comp, con);
            alerts.add(a);
        }
        return alerts;
    }

    public void updateCache(HealthDataCache cache) {
        this._cache = cache;
        Alerts alertsRecord = this._cache.getAlerts();
        this._alertsMap = alertsRecord != null ? alertsRecord.getMapFields() : new HashMap<String, Map<String, String>>();
    }

    public Map<String, Map<String, String>> getAlertsMap() {
        return this._alertsMap;
    }
}

