/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.helix.HelixConstants;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.PropertyKey;
import org.apache.helix.model.ClusterConstraints;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Message;
import org.apache.helix.model.StateModelDefinition;
import org.apache.log4j.Logger;

public class ClusterDataCache {
    Map<String, LiveInstance> _liveInstanceMap;
    Map<String, IdealState> _idealStateMap;
    Map<String, StateModelDefinition> _stateModelDefMap;
    Map<String, InstanceConfig> _instanceConfigMap;
    Map<String, ClusterConstraints> _constraintMap;
    Map<String, Map<String, Map<String, CurrentState>>> _currentStateMap;
    Map<String, Map<String, Message>> _messageMap;
    private static final Logger LOG = Logger.getLogger((String)ClusterDataCache.class.getName());

    public boolean refresh(HelixDataAccessor accessor) {
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        this._idealStateMap = accessor.getChildValuesMap(keyBuilder.idealStates());
        this._liveInstanceMap = accessor.getChildValuesMap(keyBuilder.liveInstances());
        for (LiveInstance instance : this._liveInstanceMap.values()) {
            LOG.trace((Object)("live instance: " + instance.getInstanceName() + " " + instance.getSessionId()));
        }
        this._stateModelDefMap = accessor.getChildValuesMap(keyBuilder.stateModelDefs());
        this._instanceConfigMap = accessor.getChildValuesMap(keyBuilder.instanceConfigs());
        this._constraintMap = accessor.getChildValuesMap(keyBuilder.constraints());
        HashMap msgMap = new HashMap();
        for (String instanceName : this._liveInstanceMap.keySet()) {
            Map map = accessor.getChildValuesMap(keyBuilder.messages(instanceName));
            msgMap.put(instanceName, map);
        }
        this._messageMap = Collections.unmodifiableMap(msgMap);
        HashMap allCurStateMap = new HashMap();
        for (String instanceName : this._liveInstanceMap.keySet()) {
            LiveInstance liveInstance = this._liveInstanceMap.get(instanceName);
            String sessionId = liveInstance.getSessionId();
            if (!allCurStateMap.containsKey(instanceName)) {
                allCurStateMap.put(instanceName, new HashMap());
            }
            Map curStateMap = (Map)allCurStateMap.get(instanceName);
            Map map = accessor.getChildValuesMap(keyBuilder.currentStates(instanceName, sessionId));
            curStateMap.put(sessionId, map);
        }
        for (String instance : allCurStateMap.keySet()) {
            allCurStateMap.put(instance, Collections.unmodifiableMap((Map)allCurStateMap.get(instance)));
        }
        this._currentStateMap = Collections.unmodifiableMap(allCurStateMap);
        return true;
    }

    public Map<String, IdealState> getIdealStates() {
        return this._idealStateMap;
    }

    public Map<String, LiveInstance> getLiveInstances() {
        return this._liveInstanceMap;
    }

    public Map<String, CurrentState> getCurrentState(String instanceName, String clientSessionId) {
        return this._currentStateMap.get(instanceName).get(clientSessionId);
    }

    public Map<String, Message> getMessages(String instanceName) {
        Map<String, Message> map = this._messageMap.get(instanceName);
        if (map != null) {
            return map;
        }
        return Collections.emptyMap();
    }

    public StateModelDefinition getStateModelDef(String stateModelDefRef) {
        return this._stateModelDefMap.get(stateModelDefRef);
    }

    public IdealState getIdealState(String resourceName) {
        return this._idealStateMap.get(resourceName);
    }

    public Map<String, InstanceConfig> getInstanceConfigMap() {
        return this._instanceConfigMap;
    }

    public Set<String> getDisabledInstancesForPartition(String partition) {
        HashSet<String> disabledInstancesSet = new HashSet<String>();
        for (String instance : this._instanceConfigMap.keySet()) {
            InstanceConfig config = this._instanceConfigMap.get(instance);
            if (config.getInstanceEnabled() && config.getInstanceEnabledForPartition(partition)) continue;
            disabledInstancesSet.add(instance);
        }
        return disabledInstancesSet;
    }

    public int getReplicas(String resourceName) {
        int replicas = -1;
        if (this._idealStateMap.containsKey(resourceName)) {
            String replicasStr = this._idealStateMap.get(resourceName).getReplicas();
            if (replicasStr != null) {
                if (replicasStr.equals(HelixConstants.StateModelToken.ANY_LIVEINSTANCE.toString())) {
                    replicas = this._liveInstanceMap.size();
                } else {
                    try {
                        replicas = Integer.parseInt(replicasStr);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("invalid replicas string: " + replicasStr));
                    }
                }
            } else {
                LOG.error((Object)("idealState for resource: " + resourceName + " does NOT have replicas"));
            }
        }
        return replicas;
    }

    public ClusterConstraints getConstraint(ClusterConstraints.ConstraintType type) {
        if (this._constraintMap != null) {
            return this._constraintMap.get(type.toString());
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("liveInstaceMap:" + this._liveInstanceMap).append("\n");
        sb.append("idealStateMap:" + this._idealStateMap).append("\n");
        sb.append("stateModelDefMap:" + this._stateModelDefMap).append("\n");
        sb.append("instanceConfigMap:" + this._instanceConfigMap).append("\n");
        sb.append("messageMap:" + this._messageMap).append("\n");
        return sb.toString();
    }
}

