/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.healthcheck;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.helix.ConfigAccessor;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.controller.pipeline.Pipeline;
import org.apache.helix.controller.pipeline.Stage;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.ReadHealthDataStage;
import org.apache.helix.controller.stages.StatsAggregationStage;
import org.apache.helix.model.ConfigScope;
import org.apache.helix.model.builder.ConfigScopeBuilder;
import org.apache.helix.monitoring.mbeans.ClusterAlertMBeanCollection;
import org.apache.helix.monitoring.mbeans.HelixStageLatencyMonitor;
import org.apache.log4j.Logger;

public class HealthStatsAggregator {
    private static final Logger LOG = Logger.getLogger(HealthStatsAggregator.class);
    public static final int DEFAULT_HEALTH_CHECK_LATENCY = 30000;
    private final HelixManager _manager;
    private final Pipeline _healthStatsAggregationPipeline;
    private final ClusterAlertMBeanCollection _alertItemCollection;
    private final Map<String, HelixStageLatencyMonitor> _stageLatencyMonitorMap = new HashMap<String, HelixStageLatencyMonitor>();

    public HealthStatsAggregator(HelixManager manager) {
        this._manager = manager;
        this._healthStatsAggregationPipeline = new Pipeline();
        this._healthStatsAggregationPipeline.addStage(new ReadHealthDataStage());
        StatsAggregationStage statAggregationStage = new StatsAggregationStage();
        this._healthStatsAggregationPipeline.addStage(statAggregationStage);
        this._alertItemCollection = statAggregationStage.getClusterAlertMBeanCollection();
        this.registerStageLatencyMonitor(this._healthStatsAggregationPipeline);
    }

    private void registerStageLatencyMonitor(Pipeline pipeline) {
        for (Stage stage : pipeline.getStages()) {
            String stgName = stage.getStageName();
            if (!this._stageLatencyMonitorMap.containsKey(stgName)) {
                try {
                    this._stageLatencyMonitorMap.put(stage.getStageName(), new HelixStageLatencyMonitor(this._manager.getClusterName(), stgName));
                }
                catch (Exception e) {
                    LOG.error((Object)("Couldn't create StageLatencyMonitor mbean for stage: " + stgName), (Throwable)e);
                }
                continue;
            }
            LOG.error((Object)("StageLatencyMonitor for stage: " + stgName + " already exists. Skip register it"));
        }
    }

    public synchronized void aggregate() {
        if (!this.isEnabled()) {
            LOG.info((Object)"HealthAggregationTask is disabled.");
            return;
        }
        if (!this._manager.isLeader()) {
            LOG.error((Object)("Cluster manager: " + this._manager.getInstanceName() + " is not leader. Pipeline will not be invoked"));
            return;
        }
        try {
            ClusterEvent event = new ClusterEvent("healthChange");
            event.addAttribute("helixmanager", this._manager);
            event.addAttribute("HelixStageLatencyMonitorMap", this._stageLatencyMonitorMap);
            this._healthStatsAggregationPipeline.handle(event);
            this._healthStatsAggregationPipeline.finish();
        }
        catch (Exception e) {
            LOG.error((Object)("Exception while executing pipeline: " + this._healthStatsAggregationPipeline), (Throwable)e);
        }
    }

    private boolean isEnabled() {
        ConfigAccessor configAccessor = this._manager.getConfigAccessor();
        boolean enabled = true;
        if (configAccessor != null) {
            ConfigScope scope = new ConfigScopeBuilder().forCluster(this._manager.getClusterName()).build();
            String isEnabled = configAccessor.get(scope, "healthChange.enabled");
            if (isEnabled != null) {
                enabled = new Boolean(isEnabled);
            }
        } else {
            LOG.debug((Object)"File-based cluster manager doesn't support disable healthChange");
        }
        return enabled;
    }

    public void init() {
        HelixDataAccessor accessor = this._manager.getHelixDataAccessor();
        List<String> existingHealthRecordNames = accessor.getChildNames(accessor.keyBuilder().healthReports(this._manager.getInstanceName()));
        for (String healthReportName : existingHealthRecordNames) {
            LOG.info((Object)("Removing old healthrecord " + healthReportName));
            accessor.removeProperty(accessor.keyBuilder().healthReport(this._manager.getInstanceName(), healthReportName));
        }
    }

    public void reset() {
        this._alertItemCollection.reset();
        for (HelixStageLatencyMonitor stgLatencyMonitor : this._stageLatencyMonitorMap.values()) {
            stgLatencyMonitor.reset();
        }
    }
}

