/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.messaging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.helix.ClusterMessagingService;
import org.apache.helix.ConfigAccessor;
import org.apache.helix.Criteria;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.InstanceType;
import org.apache.helix.PropertyKey;
import org.apache.helix.messaging.AsyncCallback;
import org.apache.helix.messaging.CriteriaEvaluator;
import org.apache.helix.messaging.handling.AsyncCallbackService;
import org.apache.helix.messaging.handling.HelixTaskExecutor;
import org.apache.helix.messaging.handling.MessageHandlerFactory;
import org.apache.helix.model.ConfigScope;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Message;
import org.apache.helix.model.builder.ConfigScopeBuilder;
import org.apache.log4j.Logger;

public class DefaultMessagingService
implements ClusterMessagingService {
    private final HelixManager _manager;
    private final CriteriaEvaluator _evaluator;
    private final HelixTaskExecutor _taskExecutor;
    private final AsyncCallbackService _asyncCallbackService;
    private static Logger _logger = Logger.getLogger(DefaultMessagingService.class);
    ConcurrentHashMap<String, MessageHandlerFactory> _messageHandlerFactoriestobeAdded = new ConcurrentHashMap();

    public DefaultMessagingService(HelixManager manager) {
        this._manager = manager;
        this._evaluator = new CriteriaEvaluator();
        this._taskExecutor = new HelixTaskExecutor();
        this._asyncCallbackService = new AsyncCallbackService();
        this._taskExecutor.registerMessageHandlerFactory(Message.MessageType.TASK_REPLY.toString(), this._asyncCallbackService);
    }

    @Override
    public int send(Criteria recipientCriteria, Message messageTemplate) {
        return this.send(recipientCriteria, messageTemplate, null, -1);
    }

    @Override
    public int send(Criteria recipientCriteria, Message message, AsyncCallback callbackOnReply, int timeOut) {
        return this.send(recipientCriteria, message, callbackOnReply, timeOut, 0);
    }

    @Override
    public int send(Criteria recipientCriteria, Message message, AsyncCallback callbackOnReply, int timeOut, int retryCount) {
        Map<InstanceType, List<Message>> generateMessage = this.generateMessage(recipientCriteria, message);
        int totalMessageCount = 0;
        for (List<Message> messages : generateMessage.values()) {
            totalMessageCount += messages.size();
        }
        _logger.info((Object)("Send " + totalMessageCount + " messages with criteria " + recipientCriteria));
        if (totalMessageCount == 0) {
            return 0;
        }
        String correlationId = null;
        if (callbackOnReply != null) {
            int totalTimeout = timeOut * (retryCount + 1);
            if (totalTimeout < 0) {
                totalTimeout = -1;
            }
            callbackOnReply.setTimeout(totalTimeout);
            correlationId = UUID.randomUUID().toString();
            for (List<Message> messages : generateMessage.values()) {
                callbackOnReply.setMessagesSent(messages);
            }
            this._asyncCallbackService.registerAsyncCallback(correlationId, callbackOnReply);
        }
        for (InstanceType receiverType : generateMessage.keySet()) {
            List<Message> list = generateMessage.get((Object)receiverType);
            for (Message tempMessage : list) {
                tempMessage.setRetryCount(retryCount);
                tempMessage.setExecutionTimeout(timeOut);
                tempMessage.setSrcInstanceType(this._manager.getInstanceType());
                if (correlationId != null) {
                    tempMessage.setCorrelationId(correlationId);
                }
                HelixDataAccessor accessor = this._manager.getHelixDataAccessor();
                PropertyKey.Builder keyBuilder = accessor.keyBuilder();
                if (receiverType == InstanceType.CONTROLLER) {
                    accessor.setProperty(keyBuilder.controllerMessage(tempMessage.getId()), tempMessage);
                }
                if (receiverType != InstanceType.PARTICIPANT) continue;
                accessor.setProperty(keyBuilder.message(tempMessage.getTgtName(), tempMessage.getId()), tempMessage);
            }
        }
        if (callbackOnReply != null) {
            callbackOnReply.startTimer();
        }
        return totalMessageCount;
    }

    @Override
    public Map<InstanceType, List<Message>> generateMessage(Criteria recipientCriteria, Message message) {
        HashMap<InstanceType, List<Message>> messagesToSendMap = new HashMap<InstanceType, List<Message>>();
        InstanceType instanceType = recipientCriteria.getRecipientInstanceType();
        if (instanceType == InstanceType.CONTROLLER) {
            List<Message> messages = this.generateMessagesForController(message);
            messagesToSendMap.put(InstanceType.CONTROLLER, messages);
        } else if (instanceType == InstanceType.PARTICIPANT) {
            ArrayList<Message> messages = new ArrayList<Message>();
            List<Map<String, String>> matchedList = this._evaluator.evaluateCriteria(recipientCriteria, this._manager);
            if (!matchedList.isEmpty()) {
                HashMap<String, String> sessionIdMap = new HashMap<String, String>();
                if (recipientCriteria.isSessionSpecific()) {
                    HelixDataAccessor accessor = this._manager.getHelixDataAccessor();
                    PropertyKey.Builder keyBuilder = accessor.keyBuilder();
                    List liveInstances = accessor.getChildValues(keyBuilder.liveInstances());
                    for (LiveInstance liveInstance : liveInstances) {
                        sessionIdMap.put(liveInstance.getInstanceName(), liveInstance.getSessionId());
                    }
                }
                for (Map<String, String> map : matchedList) {
                    String id = UUID.randomUUID().toString();
                    Message newMessage = new Message(message.getRecord(), id);
                    String srcInstanceName = this._manager.getInstanceName();
                    String tgtInstanceName = map.get("instanceName");
                    if (recipientCriteria.isSelfExcluded() && srcInstanceName.equalsIgnoreCase(tgtInstanceName)) continue;
                    newMessage.setSrcName(srcInstanceName);
                    newMessage.setTgtName(tgtInstanceName);
                    newMessage.setResourceName(map.get("resourceName"));
                    newMessage.setPartitionName(map.get("partitionName"));
                    if (recipientCriteria.isSessionSpecific()) {
                        newMessage.setTgtSessionId((String)sessionIdMap.get(tgtInstanceName));
                    }
                    messages.add(newMessage);
                }
                messagesToSendMap.put(InstanceType.PARTICIPANT, messages);
            }
        }
        return messagesToSendMap;
    }

    private List<Message> generateMessagesForController(Message message) {
        ArrayList<Message> messages = new ArrayList<Message>();
        String id = UUID.randomUUID().toString();
        Message newMessage = new Message(message.getRecord(), id);
        newMessage.setMsgId(id);
        newMessage.setSrcName(this._manager.getInstanceName());
        newMessage.setTgtName("Controller");
        messages.add(newMessage);
        return messages;
    }

    @Override
    public synchronized void registerMessageHandlerFactory(String type, MessageHandlerFactory factory) {
        if (this._manager.isConnected()) {
            this.registerMessageHandlerFactoryInternal(type, factory);
        } else {
            this._messageHandlerFactoriestobeAdded.put(type, factory);
        }
    }

    public synchronized void onConnected() {
        for (String type : this._messageHandlerFactoriestobeAdded.keySet()) {
            this.registerMessageHandlerFactoryInternal(type, this._messageHandlerFactoriestobeAdded.get(type));
        }
        this._messageHandlerFactoriestobeAdded.clear();
    }

    void registerMessageHandlerFactoryInternal(String type, MessageHandlerFactory factory) {
        _logger.info((Object)("registering msg factory for type " + type));
        int threadpoolSize = 40;
        String threadpoolSizeStr = null;
        String key = type + "." + "maxThreads";
        ConfigAccessor configAccessor = this._manager.getConfigAccessor();
        if (configAccessor != null) {
            ConfigScope scope = null;
            if (this._manager.getInstanceType() == InstanceType.PARTICIPANT || this._manager.getInstanceType() == InstanceType.CONTROLLER_PARTICIPANT) {
                scope = new ConfigScopeBuilder().forCluster(this._manager.getClusterName()).forParticipant(this._manager.getInstanceName()).build();
                threadpoolSizeStr = configAccessor.get(scope, key);
            }
            if (threadpoolSizeStr == null) {
                scope = new ConfigScopeBuilder().forCluster(this._manager.getClusterName()).build();
                threadpoolSizeStr = configAccessor.get(scope, key);
            }
        }
        if (threadpoolSizeStr != null) {
            try {
                threadpoolSize = Integer.parseInt(threadpoolSizeStr);
                if (threadpoolSize <= 0) {
                    threadpoolSize = 1;
                }
            }
            catch (Exception e) {
                _logger.error((Object)"", (Throwable)e);
            }
        }
        this._taskExecutor.registerMessageHandlerFactory(type, factory, threadpoolSize);
        this.sendNopMessage();
    }

    public void sendNopMessage() {
        if (this._manager.isConnected()) {
            try {
                Message nopMsg = new Message(Message.MessageType.NO_OP, UUID.randomUUID().toString());
                nopMsg.setSrcName(this._manager.getInstanceName());
                HelixDataAccessor accessor = this._manager.getHelixDataAccessor();
                PropertyKey.Builder keyBuilder = accessor.keyBuilder();
                if (this._manager.getInstanceType() == InstanceType.CONTROLLER || this._manager.getInstanceType() == InstanceType.CONTROLLER_PARTICIPANT) {
                    nopMsg.setTgtName("Controller");
                    accessor.setProperty(keyBuilder.controllerMessage(nopMsg.getId()), nopMsg);
                }
                if (this._manager.getInstanceType() == InstanceType.PARTICIPANT || this._manager.getInstanceType() == InstanceType.CONTROLLER_PARTICIPANT) {
                    nopMsg.setTgtName(this._manager.getInstanceName());
                    accessor.setProperty(keyBuilder.message(nopMsg.getTgtName(), nopMsg.getId()), nopMsg);
                }
            }
            catch (Exception e) {
                _logger.error((Object)e);
            }
        }
    }

    public HelixTaskExecutor getExecutor() {
        return this._taskExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sendAndWait(Criteria receipientCriteria, Message message, AsyncCallback asyncCallback, int timeOut, int retryCount) {
        int messagesSent = this.send(receipientCriteria, message, asyncCallback, timeOut, retryCount);
        if (messagesSent > 0) {
            while (!asyncCallback.isDone() && !asyncCallback.isTimedOut()) {
                AsyncCallback asyncCallback2 = asyncCallback;
                synchronized (asyncCallback2) {
                    try {
                        asyncCallback.wait();
                    }
                    catch (InterruptedException e) {
                        _logger.error((Object)e);
                        asyncCallback.setInterrupted(true);
                        break;
                    }
                }
            }
        } else {
            _logger.warn((Object)("No messages sent. For Criteria:" + receipientCriteria));
        }
        return messagesSent;
    }

    @Override
    public int sendAndWait(Criteria recipientCriteria, Message message, AsyncCallback asyncCallback, int timeOut) {
        return this.sendAndWait(recipientCriteria, message, asyncCallback, timeOut, 0);
    }
}

