/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.engines.htmlextractor.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.stanbol.enhancer.engines.htmlextractor.impl.BundleURIResolver;
import org.apache.stanbol.enhancer.engines.htmlextractor.impl.DOMUtils;
import org.apache.stanbol.enhancer.engines.htmlextractor.impl.HtmlExtractionComponent;
import org.apache.stanbol.enhancer.engines.htmlextractor.impl.InitializationException;
import org.apache.stanbol.enhancer.engines.htmlextractor.impl.XsltExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class HtmlExtractionRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(HtmlExtractionRegistry.class);
    private HashMap<String, HtmlExtractionComponent> registry = new HashMap();
    private HashSet<String> activeExtractors = new HashSet();

    public HtmlExtractionRegistry() {
    }

    public HtmlExtractionRegistry(String configFileName) throws InitializationException {
        this();
        InputStream config = this.getClass().getClassLoader().getResourceAsStream(configFileName);
        if (config == null) {
            throw new InitializationException("File not found: " + configFileName);
        }
        this.initialize(config);
    }

    public HtmlExtractionRegistry(InputStream config) throws InitializationException {
        this();
        this.initialize(config);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initialize(InputStream configFileStream) throws InitializationException {
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xPath = factory.newXPath();
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = parser.parse(new InputSource(configFileStream));
            NodeList nodes = (NodeList)xPath.evaluate("/htmlextractors/extractor", document, XPathConstants.NODESET);
            if (nodes == null) return;
            TransformerFactory transFac = TransformerFactory.newInstance();
            transFac.setURIResolver(new BundleURIResolver());
            int iCnt = nodes.getLength();
            for (int j = 0; j < iCnt; ++j) {
                Node nd = nodes.item(j);
                Node node = (Node)xPath.evaluate("@id", nd, XPathConstants.NODE);
                String id = node.getNodeValue();
                Node srcNode = (Node)xPath.evaluate("source", nd, XPathConstants.NODE);
                if (srcNode == null) continue;
                node = (Node)xPath.evaluate("@type", srcNode, XPathConstants.NODE);
                String srcType = node.getNodeValue();
                if (srcType.equals("xslt")) {
                    String rdfFormat = "rdfxml";
                    String rdfSyntax = "application/rdf+xml";
                    node = (Node)xPath.evaluate("@syntax", srcNode, XPathConstants.NODE);
                    if (node != null) {
                        rdfFormat = node.getNodeValue();
                        if (rdfFormat.equalsIgnoreCase("turtle")) {
                            rdfSyntax = "text/turtle";
                        } else if (rdfFormat.equalsIgnoreCase("xturtle")) {
                            rdfSyntax = "application/x-turtle";
                        } else if (rdfFormat.equalsIgnoreCase("ntriple")) {
                            rdfSyntax = "text/rdf+nt";
                        } else if (rdfFormat.equalsIgnoreCase("n3")) {
                            rdfSyntax = "text/rdf+n3";
                        } else if (!rdfFormat.equalsIgnoreCase("rdfxml")) {
                            throw new InitializationException("Unknown RDF Syntax: " + rdfFormat + " for " + id + " extractor");
                        }
                    }
                    String fileName = DOMUtils.getText(srcNode);
                    XsltExtractor xsltExtractor = new XsltExtractor(id, fileName, transFac);
                    xsltExtractor.setSyntax(rdfSyntax);
                    node = (Node)xPath.evaluate("@uri", srcNode, XPathConstants.NODE);
                    if (node != null) {
                        xsltExtractor.setUriParameter(node.getNodeValue());
                    }
                    this.registry.put(id, xsltExtractor);
                    this.activeExtractors.add(id);
                } else if (srcType.equals("java")) {
                    String clsName = srcNode.getNodeValue();
                    Object extractor = Class.forName(clsName).newInstance();
                    if (!(extractor instanceof HtmlExtractionComponent)) throw new InitializationException("clsName is not an HtmlExtractionComponent");
                    this.registry.put(id, (HtmlExtractionComponent)extractor);
                    this.activeExtractors.add(id);
                } else {
                    LOG.warn("No valid type for extractor found: " + id);
                }
                LOG.info("Extractor for: " + id);
            }
            return;
        }
        catch (FileNotFoundException e) {
            throw new InitializationException(e.getMessage(), e);
        }
        catch (XPathExpressionException e) {
            throw new InitializationException(e.getMessage(), e);
        }
        catch (DOMException e) {
            throw new InitializationException(e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new InitializationException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new InitializationException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new InitializationException(e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new InitializationException(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new InitializationException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new InitializationException(e.getMessage(), e);
        }
    }

    public HashMap<String, HtmlExtractionComponent> getRegistry() {
        return this.registry;
    }

    public void setRegistry(HashMap<String, HtmlExtractionComponent> registry) {
        this.registry = registry;
    }

    public Set<String> getActiveExtractors() {
        return this.activeExtractors;
    }

    public void setActiveExtractors(HashSet<String> activeExtractors) {
        this.activeExtractors = activeExtractors;
    }

    public static void main(String[] args) throws Exception {
        boolean argv = false;
        HtmlExtractionRegistry inst = new HtmlExtractionRegistry(args[0]);
        System.err.println("Active Components: " + inst.activeExtractors.size());
        for (String s : inst.activeExtractors) {
            System.err.println(s);
        }
    }

    public void add(String id, String resourceName, String type) throws InitializationException {
    }

    public void remove(String id) {
    }

    public void activate(String id) {
    }

    public void deactivate(String id) {
    }
}

