/*
 * Decompiled with CFR 0.152.
 */
package org.josql.functions.regexp;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.josql.QueryExecutionException;
import org.josql.functions.regexp.AbstractRegExpWrapper;
import org.josql.functions.regexp.RegExp;

public class StandardJavaRegExpWrapper
extends AbstractRegExpWrapper
implements RegExp {
    public static final String SUPPORTED_VERSION = "1.4";
    private final String compileMethName = "compile";
    private final String matcherMethName = "matcher";
    private final String matchesMethName = "matches";
    private final String matcherClassName = "java.util.regex.Matcher";
    private final String patternClassName = "java.util.regex.Pattern";
    private Method compileMeth = null;
    private Method matcherMeth = null;
    private Method matchesMeth = null;
    private Map patterns = new HashMap();

    public String getSupportedVersion() {
        return SUPPORTED_VERSION;
    }

    public boolean isAvailable() {
        try {
            Class.forName(this.patternClassName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean match(String pattern, String val) throws QueryExecutionException {
        try {
            Object[] args;
            Object o = this.patterns.get(pattern);
            if (o == null) {
                args = new Object[]{pattern};
                o = this.compileMeth.invoke(null, args);
                this.patterns.put(pattern, o);
            }
            args = new Object[]{val};
            Object matcher = this.matcherMeth.invoke(o, args);
            return (Boolean)this.matchesMeth.invoke(matcher, null);
        }
        catch (Exception e) {
            throw new QueryExecutionException("Unable to match value: " + val + " against pattern: " + pattern, e);
        }
    }

    public void init() throws QueryExecutionException {
        try {
            Class<?> pc = Class.forName(this.patternClassName);
            Class[] argTypes = new Class[]{String.class};
            this.compileMeth = pc.getMethod(this.compileMethName, argTypes);
            Class[] argTypes2 = new Class[]{CharSequence.class};
            this.matcherMeth = pc.getMethod(this.matcherMethName, argTypes2);
            Class<?> mc = Class.forName(this.matcherClassName);
            this.matchesMeth = mc.getMethod(this.matchesMethName, null);
        }
        catch (Exception e) {
            throw new QueryExecutionException("Unable to init", e);
        }
    }
}

