/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.examples;

import java.io.File;
import java.io.IOException;
import org.I0Itec.zkclient.IDefaultNameSpace;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.ZkServer;
import org.apache.commons.io.FileUtils;

public class ExampleHelper {
    public static ZkServer startZkServer(String zkAddr) {
        System.out.println("Start zookeeper at " + zkAddr + " in thread " + Thread.currentThread().getName());
        String zkDir = zkAddr.replace(':', '_');
        String logDir = "/tmp/" + zkDir + "/logs";
        String dataDir = "/tmp/" + zkDir + "/dataDir";
        try {
            FileUtils.deleteDirectory((File)new File(dataDir));
            FileUtils.deleteDirectory((File)new File(logDir));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        IDefaultNameSpace defaultNameSpace = new IDefaultNameSpace(){

            public void createDefaultNameSpace(ZkClient zkClient) {
            }
        };
        int port = Integer.parseInt(zkAddr.substring(zkAddr.lastIndexOf(58) + 1));
        ZkServer zkServer = new ZkServer(dataDir, logDir, defaultNameSpace, port);
        zkServer.start();
        return zkServer;
    }

    public static void stopZkServer(ZkServer zkServer) {
        if (zkServer != null) {
            zkServer.shutdown();
            System.out.println("Shut down zookeeper at port " + zkServer.getPort() + " in thread " + Thread.currentThread().getName());
        }
    }
}

