/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple.ast;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.language.simple.ast.BaseSimpleNode;
import org.apache.camel.language.simple.ast.BlockStart;
import org.apache.camel.language.simple.ast.CompositeNodes;
import org.apache.camel.language.simple.ast.DoubleQuoteStart;
import org.apache.camel.language.simple.ast.LiteralNode;
import org.apache.camel.language.simple.ast.SimpleFunctionExpression;
import org.apache.camel.language.simple.ast.SimpleNode;
import org.apache.camel.language.simple.ast.SingleQuoteStart;
import org.apache.camel.language.simple.types.SimpleIllegalSyntaxException;
import org.apache.camel.language.simple.types.SimpleParserException;
import org.apache.camel.language.simple.types.SimpleToken;
import org.apache.camel.util.StringHelper;

public class SimpleFunctionStart
extends BaseSimpleNode
implements BlockStart {
    private CompositeNodes block;

    public SimpleFunctionStart(SimpleToken token) {
        super(token);
        this.block = new CompositeNodes(token);
    }

    @Override
    public String toString() {
        return "${" + this.block + "}";
    }

    @Override
    public Expression createExpression(String expression) {
        if (this.block.getChildren().size() == 1 && this.block.getChildren().get(0) instanceof LiteralNode) {
            return this.doCreateLiteralExpression(expression);
        }
        return this.doCreateCompositeExpression(expression);
    }

    private Expression doCreateLiteralExpression(String expression) {
        SimpleFunctionExpression function = new SimpleFunctionExpression(this.getToken());
        LiteralNode literal = (LiteralNode)this.block.getChildren().get(0);
        function.addText(literal.getText());
        return function.createExpression(expression);
    }

    private Expression doCreateCompositeExpression(final String expression) {
        final SimpleToken token = this.getToken();
        return new Expression(){

            @Override
            public <T> T evaluate(Exchange exchange, Class<T> type) {
                StringBuilder sb = new StringBuilder();
                boolean quoteEmbeddedFunctions = false;
                for (SimpleNode child : SimpleFunctionStart.this.block.getChildren()) {
                    if (child instanceof LiteralNode) {
                        String text = ((LiteralNode)child).getText();
                        sb.append(text);
                        quoteEmbeddedFunctions |= ((LiteralNode)child).quoteEmbeddedNodes();
                        continue;
                    }
                    if (!(child instanceof SimpleFunctionStart) && !(child instanceof SingleQuoteStart) && !(child instanceof DoubleQuoteStart)) continue;
                    try {
                        Expression nested = child.createExpression(null);
                        String text = nested.evaluate(exchange, String.class);
                        if (text == null) continue;
                        if (quoteEmbeddedFunctions && !StringHelper.isQuoted(text)) {
                            sb.append("'").append(text).append("'");
                            continue;
                        }
                        sb.append(text);
                    }
                    catch (SimpleParserException e) {
                        throw new SimpleIllegalSyntaxException(expression, e.getIndex(), e.getMessage(), e);
                    }
                }
                String exp = sb.toString();
                SimpleFunctionExpression function = new SimpleFunctionExpression(token);
                function.addText(exp);
                try {
                    return function.createExpression(exp).evaluate(exchange, type);
                }
                catch (SimpleParserException e) {
                    throw new SimpleIllegalSyntaxException(expression, e.getIndex(), e.getMessage(), e);
                }
            }

            public String toString() {
                return expression;
            }
        };
    }

    @Override
    public boolean acceptAndAddNode(SimpleNode node) {
        if (node instanceof LiteralNode || node instanceof SimpleFunctionStart || node instanceof SingleQuoteStart || node instanceof DoubleQuoteStart) {
            this.block.addChild(node);
            return true;
        }
        return false;
    }
}

