/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.mbeans;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.helix.monitoring.mbeans.MessageQueueMonitorMBean;
import org.apache.log4j.Logger;

public class MessageQueueMonitor
implements MessageQueueMonitorMBean {
    private static final Logger LOG = Logger.getLogger(MessageQueueMonitor.class);
    private final String _clusterName;
    private final String _instanceName;
    private final MBeanServer _beanServer;
    private long _messageQueueBacklog;

    public MessageQueueMonitor(String clusterName, String instanceName) {
        this._clusterName = clusterName;
        this._instanceName = instanceName;
        this._beanServer = ManagementFactory.getPlatformMBeanServer();
        this._messageQueueBacklog = 0L;
    }

    public void setMessageQueueBacklog(long size) {
        this._messageQueueBacklog = size;
    }

    @Override
    public long getMessageQueueBacklog() {
        return this._messageQueueBacklog;
    }

    public void init() {
        try {
            this.register(this, this.getObjectName(this.getBeanName()));
        }
        catch (Exception e) {
            LOG.error((Object)"Fail to register MessageQueueMonitor", (Throwable)e);
        }
    }

    public void reset() {
        this._messageQueueBacklog = 0L;
        try {
            this.unregister(this.getObjectName(this.getBeanName()));
        }
        catch (Exception e) {
            LOG.error((Object)"Fail to register MessageQueueMonitor", (Throwable)e);
        }
    }

    @Override
    public String getSensorName() {
        return "MessageQueueStatus." + this._clusterName;
    }

    private void register(Object bean, ObjectName name) {
        try {
            if (this._beanServer.isRegistered(name)) {
                this._beanServer.unregisterMBean(name);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            LOG.info((Object)("Register MBean: " + name));
            this._beanServer.registerMBean(bean, name);
        }
        catch (Exception e) {
            LOG.warn((Object)("Could not register MBean: " + name), (Throwable)e);
        }
    }

    private void unregister(ObjectName name) {
        try {
            if (this._beanServer.isRegistered(name)) {
                LOG.info((Object)("Unregistering " + name.toString()));
                this._beanServer.unregisterMBean(name);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Could not unregister MBean: " + name), (Throwable)e);
        }
    }

    private String getClusterBeanName() {
        return String.format("%s=%s", "cluster", this._clusterName);
    }

    private String getBeanName() {
        return String.format("%s,%s=%s", this.getClusterBeanName(), "messageQueue", this._instanceName);
    }

    public ObjectName getObjectName(String name) throws MalformedObjectNameException {
        return new ObjectName(String.format("%s: %s", "ClusterStatus", name));
    }
}

