/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.mbeans;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.relation.MBeanServerNotificationFilter;
import org.apache.log4j.Logger;

public abstract class ClusterMBeanObserver
implements NotificationListener {
    protected final String _domain;
    protected MBeanServerConnection _server;
    private static final Logger _logger = Logger.getLogger(ClusterMBeanObserver.class);

    public ClusterMBeanObserver(String domain) throws InstanceNotFoundException, IOException, MalformedObjectNameException, NullPointerException {
        this._domain = domain;
        this._server = ManagementFactory.getPlatformMBeanServer();
        MBeanServerNotificationFilter filter = new MBeanServerNotificationFilter();
        filter.enableAllObjectNames();
        this._server.addNotificationListener(MBeanServerDelegate.DELEGATE_NAME, this, (NotificationFilter)filter, null);
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        MBeanServerNotification mbs = (MBeanServerNotification)notification;
        if ("JMX.mbean.registered".equals(mbs.getType())) {
            if (mbs.getMBeanName().getDomain().equalsIgnoreCase(this._domain)) {
                _logger.info((Object)("MBean Registered, name :" + mbs.getMBeanName()));
                this.onMBeanRegistered(this._server, mbs);
            }
        } else if ("JMX.mbean.unregistered".equals(mbs.getType()) && mbs.getMBeanName().getDomain().equalsIgnoreCase(this._domain)) {
            _logger.info((Object)("MBean Unregistered, name :" + mbs.getMBeanName()));
            this.onMBeanUnRegistered(this._server, mbs);
        }
    }

    public void disconnect() {
        MBeanServerNotificationFilter filter = new MBeanServerNotificationFilter();
        try {
            this._server.removeNotificationListener(MBeanServerDelegate.DELEGATE_NAME, this);
        }
        catch (Exception e) {
            _logger.error((Object)"", (Throwable)e);
        }
    }

    public abstract void onMBeanRegistered(MBeanServerConnection var1, MBeanServerNotification var2);

    public abstract void onMBeanUnRegistered(MBeanServerConnection var1, MBeanServerNotification var2);
}

