/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.security;

import javax.enterprise.inject.Alternative;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.exception.UnauthorizedException;
import org.uberfire.backend.server.security.FileSystemResourceAdaptor;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.security.authz.AuthorizationResult;
import org.uberfire.security.authz.ProfileDecisionManager;
import org.uberfire.security.impl.authz.DefaultProfileDecisionManager;
import org.uberfire.security.impl.authz.RuntimeResourceDecisionManager;
import org.uberfire.security.impl.authz.RuntimeResourceManager;

@Alternative
public class FileSystemAuthorizationManager
implements AuthorizationManager {
    private final RuntimeResourceDecisionManager decisionManager = new RuntimeResourceDecisionManager(new RuntimeResourceManager());
    private final ProfileDecisionManager profileDecisionManager = new DefaultProfileDecisionManager();

    public boolean supports(Resource resource) {
        return resource != null && (resource instanceof FileSystem || resource instanceof FileSystemResourceAdaptor);
    }

    public boolean authorize(Resource resource, User subject) throws UnauthorizedException {
        PortablePreconditions.checkNotNull((String)"subject", (Object)subject);
        FileSystemResourceAdaptor fileSystemResource = resource instanceof FileSystem ? new FileSystemResourceAdaptor((FileSystem)resource) : (FileSystemResourceAdaptor)resource;
        AuthorizationResult finalResult = this.decisionManager.decide((Resource)fileSystemResource, subject, this.profileDecisionManager);
        return finalResult.equals(AuthorizationResult.ACCESS_ABSTAIN) || finalResult.equals(AuthorizationResult.ACCESS_GRANTED);
    }
}

