/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.menu;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.Stack;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.ListItem;
import org.gwtbootstrap3.client.ui.base.AbstractListItem;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.client.menu.AuthFilterMenuVisitor;
import org.uberfire.client.views.pfly.menu.Bs3DropDownMenu;
import org.uberfire.client.views.pfly.menu.HasMenuItems;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.menu.EnabledStateChangeListener;
import org.uberfire.workbench.model.menu.MenuCustom;
import org.uberfire.workbench.model.menu.MenuGroup;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuItemCommand;
import org.uberfire.workbench.model.menu.MenuItemPlain;
import org.uberfire.workbench.model.menu.MenuVisitor;
import org.uberfire.workbench.model.menu.Menus;

public class Bs3Menus {
    public static void constructMenuView(Menus menus, AuthorizationManager authzManager, User identity, final HasMenuItems topLevelWidget) {
        MenuVisitor viewBuilder = new MenuVisitor(){
            Stack<HasMenuItems> parentMenus = new Stack();

            public boolean visitEnter(Menus menus) {
                this.parentMenus.push(topLevelWidget);
                return true;
            }

            public void visitLeave(Menus menus) {
                this.parentMenus.pop();
            }

            public boolean visitEnter(MenuGroup menuGroup) {
                this.parentMenus.push(new Bs3DropDownMenu(menuGroup.getCaption()));
                return true;
            }

            public void visitLeave(MenuGroup menuGroup) {
                Bs3DropDownMenu finishedMenu = (Bs3DropDownMenu)this.parentMenus.pop();
                this.parentMenus.peek().addMenuItem(menuGroup.getPosition(), (AbstractListItem)finishedMenu);
            }

            public void visit(MenuCustom<?> menuCustom) {
                AbstractListItem view;
                Widget customMenuItem = ((IsWidget)menuCustom.build()).asWidget();
                if (customMenuItem instanceof AbstractListItem) {
                    view = (AbstractListItem)customMenuItem;
                } else {
                    Anchor anchor = new Anchor();
                    anchor.add((IsWidget)customMenuItem);
                    ListItem container = new ListItem();
                    container.add((Widget)anchor);
                    view = container;
                }
                this.setupEnableDisable((MenuItem)menuCustom, view);
                this.parentMenus.peek().addMenuItem(menuCustom.getPosition(), view);
            }

            public void visit(final MenuItemCommand menuItemCommand) {
                AnchorListItem listItem = new AnchorListItem(menuItemCommand.getCaption());
                this.setupEnableDisable((MenuItem)menuItemCommand, (AbstractListItem)listItem);
                listItem.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        menuItemCommand.getCommand().execute();
                    }
                });
                this.parentMenus.peek().addMenuItem(menuItemCommand.getPosition(), (AbstractListItem)listItem);
            }

            public void visit(MenuItemPlain menuItemPlain) {
                AnchorListItem view = new AnchorListItem(menuItemPlain.getCaption());
                this.setupEnableDisable((MenuItem)menuItemPlain, (AbstractListItem)view);
                this.parentMenus.peek().addMenuItem(menuItemPlain.getPosition(), (AbstractListItem)view);
            }

            private void setupEnableDisable(MenuItem model, final AbstractListItem view) {
                view.setEnabled(model.isEnabled());
                model.addEnabledStateChangeListener(new EnabledStateChangeListener(){

                    public void enabledStateChanged(boolean enabled) {
                        view.setEnabled(enabled);
                    }
                });
            }
        };
        menus.accept((MenuVisitor)new AuthFilterMenuVisitor(authzManager, identity, viewBuilder));
    }
}

