/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.tab;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import org.gwtbootstrap3.client.shared.event.TabShowEvent;
import org.gwtbootstrap3.client.shared.event.TabShowHandler;
import org.gwtbootstrap3.client.shared.event.TabShownEvent;
import org.gwtbootstrap3.client.shared.event.TabShownHandler;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.NavTabs;
import org.gwtbootstrap3.client.ui.TabContent;
import org.gwtbootstrap3.client.ui.TabListItem;
import org.gwtbootstrap3.client.ui.TabPanel;
import org.gwtbootstrap3.client.ui.constants.IconPosition;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.constants.Toggle;
import org.uberfire.client.views.pfly.tab.TabPanelEntry;

@Dependent
public class TabPanelWithDropdowns
extends Composite {
    private static TabPanelWithDropdownsBinder uiBinder = (TabPanelWithDropdownsBinder)GWT.create(TabPanelWithDropdownsBinder.class);
    @UiField
    protected NavTabs tabBar;
    @UiField
    protected TabContent tabContent;
    private final Set<Widget> activatableWidgets = new HashSet<Widget>();
    private final TabShowHandler individualTabShowHandler = new TabShowHandler(){

        public void onShow(TabShowEvent showEvent) {
            for (Widget w : TabPanelWithDropdowns.this.activatableWidgets) {
                if (showEvent.getTab().asWidget() == w) continue;
                w.removeStyleName("active");
            }
            TabPanelWithDropdowns.this.fireEvent((GwtEvent)showEvent);
        }
    };
    private final TabShownHandler individualTabShownHandler = new TabShownHandler(){

        public void onShown(TabShownEvent shownEvent) {
            TabPanelWithDropdowns.this.fireEvent((GwtEvent)shownEvent);
        }
    };
    private final Multimap<TabPanelEntry, HandlerRegistration> tabHandlerRegistrations = HashMultimap.create();
    private final Set<TabPanelEntry> allContentTabs = new HashSet<TabPanelEntry>();

    public HandlerRegistration addShowHandler(TabShowHandler tabShowHandler) {
        return this.addHandler((EventHandler)tabShowHandler, TabShowEvent.getType());
    }

    public HandlerRegistration addShownHandler(TabShownHandler tabShownHandler) {
        return this.addHandler((EventHandler)tabShownHandler, TabShownEvent.getType());
    }

    @PostConstruct
    public void init() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
    }

    public TabPanelEntry addItem(String label, Widget content) {
        TabPanelEntry tab = new TabPanelEntry(label, content);
        this.addItem(tab);
        return tab;
    }

    public void addItem(TabPanelEntry tab) {
        this.allContentTabs.add(tab);
        this.tabHandlerRegistrations.put((Object)tab, (Object)tab.getTabWidget().addShowHandler(this.individualTabShowHandler));
        this.tabHandlerRegistrations.put((Object)tab, (Object)tab.getTabWidget().addShownHandler(this.individualTabShownHandler));
        this.activatableWidgets.add((Widget)tab.getTabWidget());
        this.tabBar.add((Widget)tab.getTabWidget());
        this.tabContent.add((Widget)tab.getContentPane());
    }

    public boolean remove(TabPanelEntry tab) {
        for (HandlerRegistration registration : this.tabHandlerRegistrations.removeAll((Object)tab)) {
            registration.removeHandler();
        }
        boolean removed = this.tabBar.remove((Widget)tab.getTabWidget());
        this.tabContent.remove((Widget)tab.getContentPane());
        this.activatableWidgets.remove((Object)tab.getTabWidget());
        this.allContentTabs.remove(tab);
        return removed;
    }

    public DropDownTab addDropdownTab(String label) {
        AnchorListItem tab = new AnchorListItem(label);
        tab.setIcon(IconType.ANGLE_DOWN);
        tab.setIconPosition(IconPosition.RIGHT);
        tab.addStyleName("dropdown-toggle");
        tab.setDataToggle(Toggle.DROPDOWN);
        DropDownTab dropDownTab = new DropDownTab(tab);
        tab.add((Widget)dropDownTab);
        this.addDropdownTab(dropDownTab);
        return dropDownTab;
    }

    public void addDropdownTab(DropDownTab contents) {
        AnchorListItem tab = contents.owningTab;
        this.activatableWidgets.add((Widget)tab);
        this.tabBar.add((Widget)tab);
    }

    public void clear() {
        for (HandlerRegistration registration : this.tabHandlerRegistrations.values()) {
            registration.removeHandler();
        }
        this.tabHandlerRegistrations.clear();
        this.tabBar.clear();
        this.activatableWidgets.clear();
        this.tabContent.clear();
        this.allContentTabs.clear();
    }

    public TabPanelEntry getActiveTab() {
        for (TabPanelEntry entry : this.allContentTabs) {
            if (!entry.isActive()) continue;
            return entry;
        }
        return null;
    }

    public int getSelectedTabIndex() {
        TabPanelEntry activeTab = this.getActiveTab();
        if (activeTab == null) {
            return -1;
        }
        return this.tabBar.getWidgetIndex((Widget)activeTab.getTabWidget());
    }

    public void selectTabIndex(int index) {
        TabListItem item = (TabListItem)this.tabBar.getWidget(index);
        if (item != null) {
            item.showTab();
        }
    }

    public TabPanelEntry findEntryForTabWidget(TabListItem tabWidget) {
        for (TabPanelEntry entry : this.allContentTabs) {
            if (entry.getTabWidget() != tabWidget) continue;
            return entry;
        }
        return null;
    }

    public class DropDownTab
    extends DropDownMenu {
        private final AnchorListItem owningTab;
        private final List<TabPanelEntry> contents = new ArrayList<TabPanelEntry>();
        private final Multimap<TabPanelEntry, HandlerRegistration> tabHandlerRegistrations = HashMultimap.create();

        public DropDownTab(AnchorListItem owningTab) {
            this.owningTab = owningTab;
            this.addStyleName("uf-dropdown-tab-menu-container");
        }

        public TabPanelEntry addItem(String label, Widget content) {
            TabPanelEntry tab = new TabPanelEntry(label, content);
            this.addItem(tab);
            return tab;
        }

        public void addItem(TabPanelEntry tab) {
            tab.setInDropdown(true);
            this.contents.add(tab);
            TabPanelWithDropdowns.this.allContentTabs.add(tab);
            TabPanelEntry.DropDownTabListItem tabWidget = tab.getTabWidget();
            TabPanelWithDropdowns.this.activatableWidgets.add(tabWidget);
            this.tabHandlerRegistrations.put((Object)tab, (Object)tabWidget.addShowHandler(TabPanelWithDropdowns.this.individualTabShowHandler));
            this.tabHandlerRegistrations.put((Object)tab, (Object)tabWidget.addShownHandler(TabPanelWithDropdowns.this.individualTabShownHandler));
            this.tabHandlerRegistrations.put((Object)tab, (Object)tabWidget.addShownHandler(new TabShownHandler(){

                public void onShown(TabShownEvent event) {
                    DropDownTab.this.getParent().addStyleName("active");
                }
            }));
            this.add((Widget)tabWidget);
            TabPanelWithDropdowns.this.tabContent.add((Widget)tab.getContentPane());
        }

        public void setText(String text) {
            this.owningTab.setText(text);
        }

        public void clear() {
            for (TabPanelEntry tab : this.contents) {
                tab.getContentPane().removeFromParent();
                tab.getTabWidget().removeFromParent();
                for (HandlerRegistration handlerRegistration : this.tabHandlerRegistrations.removeAll((Object)tab)) {
                    handlerRegistration.removeHandler();
                }
                TabPanelWithDropdowns.this.activatableWidgets.remove((Object)tab.getTabWidget());
                TabPanelWithDropdowns.this.allContentTabs.remove(tab);
            }
            this.contents.clear();
        }

        public int getTabWidth() {
            return this.owningTab.getOffsetWidth();
        }
    }

    static interface TabPanelWithDropdownsBinder
    extends UiBinder<TabPanel, TabPanelWithDropdowns> {
    }
}

