/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jboss.resteasy.core.ExceptionAdapter;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;

public final class TypeConverter {
    private static final String VALUE_OF_METHOD = "valueOf";
    private static final Map<Class<?>, Class<?>> PRIMITIVES = new HashMap();

    private TypeConverter() {
    }

    public static <T> T getType(Class<T> targetType, String source) {
        T result;
        if (String.class.equals(targetType)) {
            return targetType.cast(source);
        }
        if (Date.class.isAssignableFrom(targetType)) {
            throw new IllegalArgumentException(Messages.MESSAGES.dateInstancesNotSupported());
        }
        if (Boolean.class.equals(targetType) || Boolean.TYPE.equals(targetType)) {
            return targetType.cast(TypeConverter.getBooleanValue(source));
        }
        try {
            result = TypeConverter.getTypeViaValueOfMethod(source, targetType);
        }
        catch (NoSuchMethodException e) {
            LogMessages.LOGGER.noValueOfMethodAvailable(targetType.getSimpleName());
            result = TypeConverter.getTypeViaStringConstructor(source, targetType);
        }
        return result;
    }

    public static boolean isConvertable(Class<?> targetType) {
        if (Boolean.class.equals(targetType)) {
            return true;
        }
        if (targetType.isPrimitive()) {
            return true;
        }
        try {
            targetType.getDeclaredMethod(VALUE_OF_METHOD, String.class);
            return true;
        }
        catch (NoSuchMethodException e) {
            try {
                targetType.getDeclaredConstructor(String.class);
                return true;
            }
            catch (NoSuchMethodException e1) {
                return false;
            }
        }
    }

    public static Boolean getBooleanValue(String source) {
        if ("Y".equalsIgnoreCase(source) || "T".equalsIgnoreCase(source) || "Yes".equalsIgnoreCase(source) || "1".equalsIgnoreCase(source)) {
            return Boolean.TRUE;
        }
        if ("N".equals(source) || "F".equals(source) || "No".equals(source) || "0".equalsIgnoreCase(source)) {
            return Boolean.FALSE;
        }
        return Boolean.valueOf(source);
    }

    public static <T> T getTypeViaValueOfMethod(String source, Class<T> targetType) throws NoSuchMethodException {
        Class<Object> actualTarget = targetType;
        if (targetType.isPrimitive()) {
            actualTarget = PRIMITIVES.get(targetType);
        }
        Object result = null;
        try {
            Method valueOf = actualTarget.getDeclaredMethod(VALUE_OF_METHOD, String.class);
            Object value = valueOf.invoke(null, source);
            if (actualTarget.equals(targetType) && targetType.isInstance(value)) {
                result = targetType.cast(value);
            } else if (!actualTarget.equals(targetType) && actualTarget.isInstance(value)) {
                result = value;
            }
        }
        catch (IllegalAccessException e) {
            throw new ExceptionAdapter(e);
        }
        catch (InvocationTargetException e) {
            throw new ExceptionAdapter(e);
        }
        return (T)result;
    }

    private static <T> T getTypeViaStringConstructor(String source, Class<T> targetType) {
        T result = null;
        Constructor<T> c = null;
        try {
            c = targetType.getDeclaredConstructor(String.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(Messages.MESSAGES.hasNoStringConstructor(targetType.getName()), e);
        }
        try {
            result = c.newInstance(source);
        }
        catch (InstantiationException e) {
            throw new ExceptionAdapter(e);
        }
        catch (IllegalAccessException e) {
            throw new ExceptionAdapter(e);
        }
        catch (InvocationTargetException e) {
            throw new ExceptionAdapter(e);
        }
        return result;
    }

    static {
        PRIMITIVES.put(Integer.TYPE, Integer.class);
        PRIMITIVES.put(Double.TYPE, Double.class);
        PRIMITIVES.put(Float.TYPE, Float.class);
        PRIMITIVES.put(Short.TYPE, Short.class);
        PRIMITIVES.put(Byte.TYPE, Byte.class);
        PRIMITIVES.put(Long.TYPE, Long.class);
    }
}

