/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.relocated.freemarker.core;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.uberfire.relocated.freemarker.core.Environment;
import org.uberfire.relocated.freemarker.core.Expression;
import org.uberfire.relocated.freemarker.core.TemplateElement;
import org.uberfire.relocated.freemarker.template.SimpleScalar;
import org.uberfire.relocated.freemarker.template.TemplateException;
import org.uberfire.relocated.freemarker.template.TemplateModel;
import org.uberfire.relocated.freemarker.template.TemplateTransformModel;

final class BlockAssignment
extends TemplateElement {
    private final String varName;
    private final Expression namespaceExp;
    private final int scope;

    BlockAssignment(TemplateElement nestedBlock, String varName, int scope, Expression namespaceExp) {
        this.nestedBlock = nestedBlock;
        this.varName = varName;
        this.namespaceExp = namespaceExp;
        this.scope = scope;
    }

    void accept(Environment env) throws TemplateException, IOException {
        if (this.nestedBlock != null) {
            env.visit(this.nestedBlock, new CaptureOutput(env), null);
        } else {
            SimpleScalar value = new SimpleScalar("");
            if (this.namespaceExp != null) {
                Environment.Namespace ns = (Environment.Namespace)this.namespaceExp.getAsTemplateModel(env);
                ns.put(this.varName, value);
            } else if (this.scope == 1) {
                env.setVariable(this.varName, value);
            } else if (this.scope == 3) {
                env.setGlobalVariable(this.varName, value);
            } else if (this.scope == 2) {
                env.setLocalVariable(this.varName, value);
            }
        }
    }

    public String getCanonicalForm() {
        String key;
        switch (this.scope) {
            case 2: {
                key = "local";
                break;
            }
            case 3: {
                key = "global";
                break;
            }
            default: {
                key = "assign";
            }
        }
        String block = this.nestedBlock == null ? "" : this.nestedBlock.getCanonicalForm();
        return "<#" + key + " " + this.varName + (this.namespaceExp != null ? " in " + this.namespaceExp.getCanonicalForm() : "") + ">" + block + "</#" + key + ">";
    }

    public String getDescription() {
        return "block assignment to variable: " + this.varName;
    }

    boolean isIgnorable() {
        return false;
    }

    private class CaptureOutput
    implements TemplateTransformModel {
        private final Environment env;
        private final Environment.Namespace fnsModel;

        CaptureOutput(Environment env) throws TemplateException {
            this.env = env;
            TemplateModel nsModel = null;
            if (BlockAssignment.this.namespaceExp != null && !((nsModel = BlockAssignment.this.namespaceExp.getAsTemplateModel(env)) instanceof Environment.Namespace)) {
                throw new TemplateException("namespace parameter does not specify a namespace. It is a " + nsModel.getClass().getName(), env);
            }
            this.fnsModel = (Environment.Namespace)nsModel;
        }

        public Writer getWriter(Writer out, Map args) {
            return new StringWriter(){

                public void close() {
                    SimpleScalar result = new SimpleScalar(this.toString());
                    switch (BlockAssignment.this.scope) {
                        case 1: {
                            if (CaptureOutput.this.fnsModel != null) {
                                CaptureOutput.this.fnsModel.put(BlockAssignment.this.varName, result);
                                break;
                            }
                            CaptureOutput.this.env.setVariable(BlockAssignment.this.varName, result);
                            break;
                        }
                        case 2: {
                            CaptureOutput.this.env.setLocalVariable(BlockAssignment.this.varName, result);
                            break;
                        }
                        case 3: {
                            CaptureOutput.this.env.setGlobalVariable(BlockAssignment.this.varName, result);
                        }
                    }
                }
            };
        }
    }
}

