/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import javax.inject.Inject;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.AbstractWorkbenchActivity;
import org.uberfire.client.mvp.LockManager;
import org.uberfire.client.mvp.LockTarget;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.WorkbenchEditorActivity;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;

public abstract class AbstractWorkbenchEditorActivity
extends AbstractWorkbenchActivity
implements WorkbenchEditorActivity {
    @Inject
    private LockManager lockManager;
    protected ObservablePath path;

    public AbstractWorkbenchEditorActivity(PlaceManager placeManager) {
        super(placeManager);
    }

    @Override
    public final void onStartup(PlaceRequest place) {
        if (place instanceof PathPlaceRequest) {
            this.onStartup(((PathPlaceRequest)place).getPath(), place);
        } else {
            super.onStartup(place);
        }
    }

    @Override
    public void onStartup(final ObservablePath path, PlaceRequest place) {
        super.onStartup(place);
        this.path = path;
        Runnable reload = new Runnable(){

            @Override
            public void run() {
                AbstractWorkbenchEditorActivity.this.onStartup(path, AbstractWorkbenchEditorActivity.this.getPlace());
            }
        };
        LockTarget.TitleProvider titleProvider = new LockTarget.TitleProvider(){

            public String getTitle() {
                return AbstractWorkbenchEditorActivity.this.getTitle();
            }
        };
        this.lockManager.init(new LockTarget((Path)path, this.getWidget().asWidget(), this.getPlace(), titleProvider, reload));
    }

    @Override
    public void onOpen() {
        super.onOpen();
        this.lockManager.acquireLockOnDemand();
    }

    @Override
    public void onSave() {
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public void onClose() {
        this.lockManager.releaseLock();
        super.onClose();
    }

    @Override
    public void onFocus() {
        super.onFocus();
        if (this.path != null) {
            this.lockManager.onFocus();
        }
    }

    public ObservablePath getPath() {
        return this.path;
    }

    public boolean isOpen() {
        return this.open;
    }
}

