/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.delegates;

import javax.ws.rs.core.Cookie;
import javax.ws.rs.ext.RuntimeDelegate;
import org.jboss.resteasy.plugins.delegates.ServerCookie;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;

public class CookieHeaderDelegate
implements RuntimeDelegate.HeaderDelegate {
    public Object fromString(String value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.cookieHeaderValueNull());
        }
        try {
            String[] parts;
            int version = 0;
            String domain = null;
            String path = null;
            String cookieName = null;
            String cookieValue = null;
            for (String part : parts = value.split("[;,]")) {
                String value1;
                String[] nv = part.split("=", 2);
                String name = nv.length > 0 ? nv[0].trim() : "";
                String string = value1 = nv.length > 1 ? nv[1].trim() : "";
                if (value1.startsWith("\"") && value1.endsWith("\"") && value1.length() > 1) {
                    value1 = value1.substring(1, value1.length() - 1);
                }
                if (!name.startsWith("$")) {
                    cookieName = name;
                    cookieValue = value1;
                    continue;
                }
                if (name.startsWith("$Version")) {
                    version = Integer.parseInt(value1);
                    continue;
                }
                if (name.startsWith("$Path")) {
                    path = value1;
                    continue;
                }
                if (!name.startsWith("$Domain")) continue;
                domain = value1;
            }
            return new Cookie(cookieName, cookieValue, path, domain, version);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(Messages.MESSAGES.failedToParseCookie(value), ex);
        }
    }

    public String toString(Object value) {
        Cookie cookie = (Cookie)value;
        StringBuffer buf = new StringBuffer();
        ServerCookie.appendCookieValue(buf, 0, cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getDomain(), null, -1, false);
        return buf.toString();
    }
}

