/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.commons.util.dirbrowser;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.wymiwyg.commons.util.dirbrowser.FilePathNode;
import org.wymiwyg.commons.util.dirbrowser.PathNode;
import org.wymiwyg.commons.util.dirbrowser.ZipPathNode;

public class PathNodeFactory {
    public static PathNode getPathNode(URL url) throws IOException {
        String scheme = url.getProtocol();
        if ("file".equals(scheme)) {
            File file;
            try {
                file = new File(new URI(url.toString()));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            return new FilePathNode(file);
        }
        if ("jar".equals(scheme)) {
            JarURLConnection connection = (JarURLConnection)url.openConnection();
            return new ZipPathNode(connection);
        }
        return null;
    }
}

