/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server;

import java.util.Set;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.annotation.WebListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.backend.vfs.impl.LockInfo;
import org.uberfire.backend.vfs.impl.LockResult;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.NoSuchFileException;

@WebListener
public class LockCleanupSessionListener
implements HttpSessionListener {
    private static final Logger logger = LoggerFactory.getLogger(LockCleanupSessionListener.class);
    @Inject
    @Named(value="configIO")
    private IOService ioService;
    @Inject
    @Named(value="systemFS")
    private FileSystem fileSystem;
    @Inject
    private Event<LockInfo> lockEvent;

    public void sessionCreated(HttpSessionEvent se) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionDestroyed(HttpSessionEvent se) {
        Set locks = (Set)se.getSession().getAttribute("uf-locks");
        if (locks != null) {
            try {
                this.ioService.startBatch(this.fileSystem);
                for (LockInfo lockInfo : locks) {
                    try {
                        Path lockPath = PathFactory.newLock((Path)lockInfo.getFile());
                        this.ioService.delete(Paths.convert(lockPath), new DeleteOption[0]);
                        this.lockEvent.fire((Object)LockResult.released((Path)lockInfo.getFile()).getLockInfo());
                    }
                    catch (NoSuchFileException e) {
                        logger.debug("Problem when releasing lock on session end (lock no longer exists): " + lockInfo, (Throwable)e);
                    }
                    catch (Throwable t) {
                        logger.warn("Problem when releasing lock on session end: " + lockInfo, t);
                    }
                }
            }
            finally {
                this.ioService.endBatch();
            }
        }
    }
}

