/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.relocated.freemarker.core;

import org.uberfire.relocated.freemarker.core.Environment;
import org.uberfire.relocated.freemarker.core.Expression;
import org.uberfire.relocated.freemarker.core.Macro;
import org.uberfire.relocated.freemarker.core.TemplateElement;
import org.uberfire.relocated.freemarker.template.TemplateException;

public final class ReturnInstruction
extends TemplateElement {
    private Expression exp;

    ReturnInstruction(Expression exp) {
        this.exp = exp;
    }

    void accept(Environment env) throws TemplateException {
        if (this.exp != null) {
            env.setLastReturnValue(this.exp.getAsTemplateModel(env));
        }
        if (this.nextSibling() != null) {
            throw Return.INSTANCE;
        }
        if (!(this.getParent() instanceof Macro) && !(this.getParent().getParent() instanceof Macro)) {
            throw Return.INSTANCE;
        }
    }

    public String getCanonicalForm() {
        String expString = this.exp == null ? "" : " " + this.exp.getCanonicalForm();
        return "<#return" + expString + "/>";
    }

    public String getDescription() {
        return "return [" + this.getStartLocation() + "]";
    }

    public static class Return
    extends RuntimeException {
        static final Return INSTANCE = new Return();

        private Return() {
        }
    }
}

