/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.bs2.dnd;

import com.allen_sauer.gwt.dnd.client.DragContext;
import com.allen_sauer.gwt.dnd.client.VetoDragException;
import com.allen_sauer.gwt.dnd.client.util.CoordinateArea;
import com.allen_sauer.gwt.dnd.client.util.CoordinateLocation;
import com.allen_sauer.gwt.dnd.client.util.Location;
import com.allen_sauer.gwt.dnd.client.util.WidgetArea;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.ApplicationScoped;
import org.uberfire.client.resources.WorkbenchResources;
import org.uberfire.client.workbench.widgets.dnd.CompassWidget;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.Position;

@ApplicationScoped
public class CompassWidgetImpl
extends PopupPanel
implements CompassWidget {
    private static Element dropTargetHighlight;
    private final Image northWidget = new Image(WorkbenchResources.INSTANCE.images().compassNorth());
    private final Image southWidget = new Image(WorkbenchResources.INSTANCE.images().compassSouth());
    private final Image eastWidget = new Image(WorkbenchResources.INSTANCE.images().compassEast());
    private final Image westWidget = new Image(WorkbenchResources.INSTANCE.images().compassWest());
    private final Image centreWidget = new Image(WorkbenchResources.INSTANCE.images().compassCentre());
    private final FlexTable container = new FlexTable();
    private CompassPosition dropTargetPosition = CompassPosition.NONE;

    public CompassWidgetImpl() {
        this.setStyleName(WorkbenchResources.INSTANCE.CSS().dropTargetCompass());
        this.container.setCellPadding(0);
        this.container.setCellSpacing(0);
        this.container.setPixelSize(100, 100);
        if (dropTargetHighlight == null) {
            dropTargetHighlight = Document.get().createDivElement();
            dropTargetHighlight.getStyle().setPosition(Style.Position.ABSOLUTE);
            dropTargetHighlight.getStyle().setVisibility(Style.Visibility.HIDDEN);
            dropTargetHighlight.setClassName(WorkbenchResources.INSTANCE.CSS().dropTargetHighlight());
            Document.get().getBody().appendChild((Node)dropTargetHighlight);
        }
        this.northWidget.getElement().getStyle().setOpacity(0.75);
        this.southWidget.getElement().getStyle().setOpacity(0.75);
        this.eastWidget.getElement().getStyle().setOpacity(0.75);
        this.westWidget.getElement().getStyle().setOpacity(0.75);
        this.northWidget.ensureDebugId("CompassWidget-north");
        this.southWidget.ensureDebugId("CompassWidget-south");
        this.eastWidget.ensureDebugId("CompassWidget-east");
        this.westWidget.ensureDebugId("CompassWidget-west");
        this.centreWidget.ensureDebugId("CompassWidget-centre");
        this.container.setWidget(0, 1, (Widget)this.northWidget);
        this.container.setWidget(1, 0, (Widget)this.westWidget);
        this.container.setWidget(1, 1, (Widget)this.centreWidget);
        this.container.setWidget(1, 2, (Widget)this.eastWidget);
        this.container.setWidget(2, 1, (Widget)this.southWidget);
        this.setWidget((Widget)this.container);
    }

    public void onEnter(DragContext context) {
        Document.get().getBody().addClassName("uf-no-select");
        this.show(context);
    }

    public void onLeave(DragContext context) {
        this.hide();
        Document.get().getBody().removeClassName("uf-no-select");
    }

    public void onMove(DragContext context) {
        CoordinateLocation l = new CoordinateLocation(context.mouseX, context.mouseY);
        WidgetArea northWidgetArea = new WidgetArea((Widget)this.northWidget, null);
        WidgetArea southWidgetArea = new WidgetArea((Widget)this.southWidget, null);
        WidgetArea eastWidgetArea = new WidgetArea((Widget)this.eastWidget, null);
        WidgetArea westWidgetArea = new WidgetArea((Widget)this.westWidget, null);
        WidgetArea centreWidgetArea = new WidgetArea((Widget)this.centreWidget, null);
        CompassPosition p = CompassPosition.NONE;
        if (northWidgetArea.intersects((Location)l)) {
            p = CompassPosition.NORTH;
        } else if (southWidgetArea.intersects((Location)l)) {
            p = CompassPosition.SOUTH;
        } else if (eastWidgetArea.intersects((Location)l)) {
            p = CompassPosition.EAST;
        } else if (westWidgetArea.intersects((Location)l)) {
            p = CompassPosition.WEST;
        } else if (centreWidgetArea.intersects((Location)l)) {
            p = CompassPosition.SELF;
        }
        if (p != this.dropTargetPosition) {
            this.dropTargetPosition = p;
            this.showDropTarget(context, p);
        }
    }

    public Position getDropPosition() {
        return this.dropTargetPosition;
    }

    public Widget getDropTarget() {
        throw new UnsupportedOperationException();
    }

    public void onDrop(DragContext context) {
        this.dropTargetPosition = CompassPosition.NONE;
        this.hideDropTarget();
    }

    public void onPreviewDrop(DragContext context) throws VetoDragException {
        throw new UnsupportedOperationException();
    }

    private void show(DragContext context) {
        Widget dropTargetParent = context.dropController.getDropTarget();
        int cxmin = dropTargetParent.getElement().getAbsoluteLeft();
        int cymin = dropTargetParent.getElement().getAbsoluteTop();
        int cxmax = dropTargetParent.getElement().getAbsoluteRight();
        int cymax = dropTargetParent.getElement().getAbsoluteBottom();
        final CoordinateArea ca = new CoordinateArea(cxmin, cymin, cxmax, cymax);
        if (!this.isAttached()) {
            this.setPopupPositionAndShow(new PopupPanel.PositionCallback(){

                public void setPosition(int offsetWidth, int offsetHeight) {
                    CompassWidgetImpl.this.setPopupPosition(ca.getCenter().getLeft() - offsetWidth / 2, ca.getCenter().getTop() - offsetHeight / 2);
                }
            });
        } else {
            this.setPopupPosition(ca.getCenter().getLeft() - this.getOffsetWidth() / 2, ca.getCenter().getTop() - this.getOffsetHeight() / 2);
        }
    }

    private void showDropTarget(DragContext context, CompassPosition p) {
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        Widget dropTargetParent = context.dropController.getDropTarget();
        switch (p) {
            case SELF: {
                x = dropTargetParent.getAbsoluteLeft();
                y = dropTargetParent.getAbsoluteTop();
                width = dropTargetParent.getOffsetWidth();
                height = dropTargetParent.getOffsetHeight();
                this.showDropTarget(x, y, width, height);
                break;
            }
            case NORTH: {
                x = dropTargetParent.getAbsoluteLeft();
                y = dropTargetParent.getAbsoluteTop();
                width = dropTargetParent.getOffsetWidth();
                height = (int)((double)dropTargetParent.getOffsetHeight() * 0.5);
                this.showDropTarget(x, y, width, height);
                break;
            }
            case SOUTH: {
                x = dropTargetParent.getAbsoluteLeft();
                height = (int)((double)dropTargetParent.getOffsetHeight() * 0.5);
                y = dropTargetParent.getOffsetHeight() + dropTargetParent.getAbsoluteTop() - height;
                width = dropTargetParent.getOffsetWidth();
                this.showDropTarget(x, y, width, height);
                break;
            }
            case EAST: {
                width = (int)((double)dropTargetParent.getOffsetWidth() * 0.5);
                x = dropTargetParent.getOffsetWidth() + dropTargetParent.getAbsoluteLeft() - width;
                y = dropTargetParent.getAbsoluteTop();
                height = dropTargetParent.getOffsetHeight();
                this.showDropTarget(x, y, width, height);
                break;
            }
            case WEST: {
                x = dropTargetParent.getAbsoluteLeft();
                y = dropTargetParent.getAbsoluteTop();
                width = (int)((double)dropTargetParent.getOffsetWidth() * 0.5);
                height = dropTargetParent.getOffsetHeight();
                this.showDropTarget(x, y, width, height);
                break;
            }
            default: {
                this.hideDropTarget();
            }
        }
    }

    private void showDropTarget(int x, int y, int width, int height) {
        dropTargetHighlight.getStyle().setLeft((double)x, Style.Unit.PX);
        dropTargetHighlight.getStyle().setWidth((double)width, Style.Unit.PX);
        dropTargetHighlight.getStyle().setTop((double)y, Style.Unit.PX);
        dropTargetHighlight.getStyle().setHeight((double)height, Style.Unit.PX);
        dropTargetHighlight.getStyle().setVisibility(Style.Visibility.VISIBLE);
        dropTargetHighlight.getStyle().setDisplay(Style.Display.BLOCK);
    }

    private void hideDropTarget() {
        dropTargetHighlight.getStyle().setVisibility(Style.Visibility.HIDDEN);
        dropTargetHighlight.getStyle().setDisplay(Style.Display.NONE);
        dropTargetHighlight.getStyle().setLeft(0.0, Style.Unit.PX);
        dropTargetHighlight.getStyle().setWidth(0.0, Style.Unit.PX);
        dropTargetHighlight.getStyle().setTop(0.0, Style.Unit.PX);
        dropTargetHighlight.getStyle().setHeight(0.0, Style.Unit.PX);
        this.dropTargetPosition = CompassPosition.NONE;
    }
}

