/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.engines.htmlextractor.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.clerezza.rdf.core.Graph;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.clerezza.rdf.core.serializedform.Parser;
import org.apache.stanbol.enhancer.engines.htmlextractor.impl.BundleURIResolver;
import org.apache.stanbol.enhancer.engines.htmlextractor.impl.ExtractorException;
import org.apache.stanbol.enhancer.engines.htmlextractor.impl.HtmlExtractionComponent;
import org.apache.stanbol.enhancer.engines.htmlextractor.impl.InitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class XsltExtractor
implements HtmlExtractionComponent {
    private static final Logger LOG = LoggerFactory.getLogger(XsltExtractor.class);
    private String uriParameter = "uri";
    private Transformer transformer;
    private String id;
    private URI source;
    private String syntax = "application/rdf+xml";

    public XsltExtractor() {
    }

    public XsltExtractor(String id, String fileName, TransformerFactory factory) throws InitializationException {
        this.id = id;
        try {
            URI location;
            this.source = location = this.getClass().getClassLoader().getResource(fileName).toURI();
        }
        catch (URISyntaxException e) {
            throw new InitializationException(e.getMessage(), e);
        }
        this.initialize(factory);
    }

    public String getUriParameter() {
        return this.uriParameter;
    }

    public void setUriParameter(String uriParameter) {
        this.uriParameter = uriParameter;
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public URI getSource() {
        return this.source;
    }

    public void setSource(URI source) {
        this.source = source;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void setSyntax(String syntax) {
        this.syntax = syntax;
    }

    @Override
    public synchronized void extract(String id, Document doc, Map<String, Object> params, MGraph result) throws ExtractorException {
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        params.put(this.uriParameter, id);
        this.initTransformerParameters(params);
        DOMSource source = new DOMSource(doc);
        ByteArrayOutputStream writer = new ByteArrayOutputStream(8192);
        StreamResult output = new StreamResult(writer);
        try {
            this.transformer.transform(source, output);
            if (LOG.isDebugEnabled()) {
                String rdf = writer.toString("UTF-8");
                LOG.debug(rdf);
            }
            ByteArrayInputStream reader = new ByteArrayInputStream(writer.toByteArray());
            Parser rdfParser = Parser.getInstance();
            Graph graph = rdfParser.parse((InputStream)reader, this.syntax);
            result.addAll((Collection)graph);
        }
        catch (TransformerException e) {
            throw new ExtractorException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ExtractorException(e.getMessage(), e);
        }
    }

    public void initialize(TransformerFactory factory) throws InitializationException {
        if (this.source == null || this.id == null) {
            throw new InitializationException("Missing source or id");
        }
        if (factory == null) {
            factory = TransformerFactory.newInstance();
            factory.setURIResolver(new BundleURIResolver());
        }
        StreamSource xsltSource = new StreamSource(this.source.toString());
        xsltSource.setSystemId(this.source.toString());
        try {
            this.transformer = factory.newTransformer(xsltSource);
        }
        catch (TransformerConfigurationException e) {
            throw new InitializationException(e.getMessage(), e);
        }
    }

    public void initTransformerParameters(Map<String, Object> params) {
        this.transformer.clearParameters();
        if (params != null) {
            Set<String> parms = params.keySet();
            for (String piter : parms) {
                this.transformer.setParameter(piter, params.get(piter));
            }
        }
    }
}

