/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.listbar;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.logical.shared.BeforeSelectionEvent;
import com.google.gwt.event.logical.shared.BeforeSelectionHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.ResizeComposite;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ButtonGroup;
import org.gwtbootstrap3.client.ui.DropDown;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.NavbarLink;
import org.gwtbootstrap3.client.ui.Panel;
import org.gwtbootstrap3.client.ui.PanelBody;
import org.gwtbootstrap3.client.ui.PanelHeader;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.Toggle;
import org.jboss.errai.ioc.client.container.IOCResolutionException;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.client.util.Layouts;
import org.uberfire.client.views.pfly.listbar.PartListDropdown;
import org.uberfire.client.views.pfly.maximize.MaximizeToggleButton;
import org.uberfire.client.workbench.PanelManager;
import org.uberfire.client.workbench.panels.MaximizeToggleButtonPresenter;
import org.uberfire.client.workbench.panels.WorkbenchPanelPresenter;
import org.uberfire.client.workbench.part.WorkbenchPartPresenter;
import org.uberfire.client.workbench.widgets.dnd.WorkbenchDragAndDropManager;
import org.uberfire.client.workbench.widgets.listbar.ListBarWidget;
import org.uberfire.client.workbench.widgets.listbar.ListbarPreferences;
import org.uberfire.client.workbench.widgets.listbar.ResizeFocusPanel;
import org.uberfire.commons.data.Pair;
import org.uberfire.mvp.Command;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.menu.EnabledStateChangeListener;
import org.uberfire.workbench.model.menu.MenuCustom;
import org.uberfire.workbench.model.menu.MenuGroup;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuItemCommand;

@Dependent
public class ListBarWidgetImpl
extends ResizeComposite
implements ListBarWidget {
    private static ListBarWidgetBinder uiBinder = (ListBarWidgetBinder)GWT.create(ListBarWidgetBinder.class);
    @Inject
    Instance<ListbarPreferences> optionalListBarPrefs;
    @Inject
    PanelManager panelManager;
    @Inject
    private AuthorizationManager authzManager;
    @Inject
    private User identity;
    @UiField
    FocusPanel container;
    @UiField
    PartListDropdown titleDropDown;
    @UiField
    PanelHeader header;
    @UiField
    Panel panel;
    @UiField
    ButtonGroup contextMenu;
    @UiField
    AnchorListItem closeButton;
    @UiField
    ButtonGroup toolBar;
    @UiField
    DropDownMenu toolBarDropDownMenu;
    @UiField
    MaximizeToggleButton maximizeButton;
    MaximizeToggleButtonPresenter maximizeButtonPresenter;
    @UiField
    PanelBody content;
    @UiField
    DropDown toolBarDropDown;
    @UiField
    Anchor toolBarDropDownMenuButton;
    WorkbenchPanelPresenter presenter;
    private final Map<PartDefinition, FlowPanel> partContentView = new HashMap<PartDefinition, FlowPanel>();
    LinkedHashSet<PartDefinition> parts = new LinkedHashSet();
    Pair<PartDefinition, FlowPanel> currentPart;

    @PostConstruct
    void postConstruct() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.maximizeButtonPresenter = new MaximizeToggleButtonPresenter((MaximizeToggleButtonPresenter.View)this.maximizeButton);
        this.titleDropDown.setHideOnSingleElement(this.getListbarPreferences().isHideTitleDropDownOnSingleElement());
        this.setupEventHandlers();
        Layouts.setToFillParent((Widget)this);
        this.scheduleResize();
    }

    void setupEventHandlers() {
        this.container.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                ListBarWidgetImpl.this.toolBarDropDown.removeStyleName("open");
                ListBarWidgetImpl.this.titleDropDown.removeStyleName("open");
            }
        });
        this.container.addFocusHandler(new FocusHandler(){

            public void onFocus(FocusEvent event) {
                if (ListBarWidgetImpl.this.currentPart != null && ListBarWidgetImpl.this.currentPart.getK1() != null) {
                    ListBarWidgetImpl.this.selectPart((PartDefinition)ListBarWidgetImpl.this.currentPart.getK1());
                }
            }
        });
        this.maximizeButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (ListBarWidgetImpl.this.maximizeButton.isMaximized()) {
                    ListBarWidgetImpl.this.toolBar.clear();
                    ListBarWidgetImpl.this.maximizeButton.addStyleName("btn");
                    ListBarWidgetImpl.this.maximizeButton.addStyleName("btn-default");
                    ListBarWidgetImpl.this.maximizeButton.addStyleName("btn-sm");
                    ListBarWidgetImpl.this.toolBar.add((Widget)ListBarWidgetImpl.this.maximizeButton);
                    ListBarWidgetImpl.this.panelManager.onPartMaximized((PartDefinition)ListBarWidgetImpl.this.currentPart.getK1());
                } else {
                    ListBarWidgetImpl.this.toolBar.clear();
                    ListBarWidgetImpl.this.toolBar.add((Widget)ListBarWidgetImpl.this.toolBarDropDown);
                    ListBarWidgetImpl.this.maximizeButton.removeStyleName("btn");
                    ListBarWidgetImpl.this.maximizeButton.removeStyleName("btn-default");
                    ListBarWidgetImpl.this.maximizeButton.removeStyleName("btn-sm");
                    ListBarWidgetImpl.this.toolBarDropDownMenu.insert((Widget)ListBarWidgetImpl.this.maximizeButton, 0);
                    ListBarWidgetImpl.this.panelManager.onPartMinimized((PartDefinition)ListBarWidgetImpl.this.currentPart.getK1());
                }
            }
        });
        this.closeButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (ListBarWidgetImpl.this.currentPart != null) {
                    ListBarWidgetImpl.this.panelManager.closePart((PartDefinition)ListBarWidgetImpl.this.currentPart.getK1());
                }
            }
        });
        this.titleDropDown.addSelectionHandler(new SelectionHandler<PartDefinition>(){

            public void onSelection(SelectionEvent<PartDefinition> event) {
                ListBarWidgetImpl.this.selectPart((PartDefinition)event.getSelectedItem());
            }
        });
        this.titleDropDown.addCloseHandler(new CloseHandler<PartDefinition>(){

            public void onClose(CloseEvent<PartDefinition> event) {
                ListBarWidgetImpl.this.panelManager.closePart((PartDefinition)event.getTarget());
            }
        });
    }

    ListbarPreferences getListbarPreferences() {
        try {
            return this.optionalListBarPrefs.isUnsatisfied() ? new ListbarPreferences() : (ListbarPreferences)this.optionalListBarPrefs.get();
        }
        catch (IOCResolutionException e) {
            return new ListbarPreferences();
        }
    }

    public void enableDnd() {
        this.titleDropDown.enableDragAndDrop();
    }

    public void disableDnd() {
        this.titleDropDown.disableDragAndDrop();
    }

    public void setPresenter(WorkbenchPanelPresenter presenter) {
        this.presenter = presenter;
    }

    public void setDndManager(WorkbenchDragAndDropManager dndManager) {
        this.titleDropDown.setDndManager(dndManager);
    }

    public void clear() {
        this.contextMenu.clear();
        this.header.clear();
        this.panel.clear();
        this.content.clear();
        this.parts.clear();
        this.partContentView.clear();
        this.titleDropDown.clear();
        this.currentPart = null;
    }

    public void addPart(WorkbenchPartPresenter.View view) {
        PartDefinition partDefinition = view.getPresenter().getDefinition();
        if (this.parts.contains(partDefinition)) {
            this.selectPart(partDefinition);
            return;
        }
        this.parts.add(partDefinition);
        FlowPanel panel = new FlowPanel();
        Layouts.setToFillParent((Widget)panel);
        panel.add((IsWidget)view);
        this.content.add((Widget)panel);
        this.partContentView.put(partDefinition, panel);
        this.titleDropDown.addPart(view);
        this.scheduleResize();
    }

    public void changeTitle(PartDefinition part, String title, IsWidget titleDecoration) {
        this.titleDropDown.changeTitle(part, title, titleDecoration);
    }

    public boolean selectPart(PartDefinition part) {
        if (!this.parts.contains(part)) {
            return false;
        }
        if (this.currentPart != null) {
            if (((PartDefinition)this.currentPart.getK1()).equals(part)) {
                return true;
            }
            this.parts.add((PartDefinition)this.currentPart.getK1());
            ((FlowPanel)this.currentPart.getK2()).getElement().getStyle().setDisplay(Style.Display.NONE);
        }
        this.currentPart = Pair.newPair((Object)part, (Object)this.partContentView.get(part));
        ((FlowPanel)this.currentPart.getK2()).getElement().getStyle().setDisplay(Style.Display.BLOCK);
        this.parts.remove(this.currentPart.getK1());
        this.titleDropDown.selectPart(part);
        this.setupContextMenu();
        this.scheduleResize();
        SelectionEvent.fire((HasSelectionHandlers)this, (Object)part);
        return true;
    }

    private void setupContextMenu() {
        this.contextMenu.clear();
        WorkbenchPartPresenter.View part = (WorkbenchPartPresenter.View)((FlowPanel)this.currentPart.getK2()).getWidget(0);
        if (part.getPresenter().getMenus() != null && part.getPresenter().getMenus().getItems().size() > 0) {
            for (MenuItem menuItem : part.getPresenter().getMenus().getItems()) {
                Widget result = this.makeItem(menuItem, true);
                if (result == null) continue;
                this.contextMenu.add(result);
            }
        }
        this.contextMenu.setVisible(this.contextMenu.getWidgetCount() > 0);
    }

    public boolean remove(PartDefinition part) {
        this.titleDropDown.removePart(part);
        if (((PartDefinition)this.currentPart.getK1()).equals(part)) {
            if (this.parts.size() > 0) {
                this.presenter.selectPart((PartDefinition)this.parts.iterator().next());
            } else {
                this.clear();
            }
        }
        boolean removed = this.parts.remove(part);
        FlowPanel view = this.partContentView.remove(part);
        if (view != null) {
            this.content.remove((Widget)view);
        }
        this.scheduleResize();
        return removed;
    }

    public void setFocus(boolean hasFocus) {
    }

    public void addOnFocusHandler(Command command) {
    }

    public int getPartsSize() {
        if (this.currentPart == null) {
            return 0;
        }
        return this.parts.size() + 1;
    }

    public HandlerRegistration addBeforeSelectionHandler(BeforeSelectionHandler<PartDefinition> handler) {
        return this.addHandler((EventHandler)handler, BeforeSelectionEvent.getType());
    }

    public HandlerRegistration addSelectionHandler(SelectionHandler<PartDefinition> handler) {
        return this.addHandler((EventHandler)handler, SelectionEvent.getType());
    }

    public void onResize() {
        if (!this.isAttached()) {
            return;
        }
        int contentHeight = this.getOffsetHeight() - this.header.getOffsetHeight();
        if (contentHeight < 0) {
            this.content.getElement().getStyle().setHeight(100.0, Style.Unit.PCT);
        } else {
            this.content.getElement().getStyle().setHeight((double)contentHeight, Style.Unit.PX);
        }
        super.onResize();
        for (int i = 0; i < this.content.getWidgetCount(); ++i) {
            FlowPanel container = (FlowPanel)this.content.getWidget(i);
            Widget containedWidget = container.getWidget(0);
            if (!(containedWidget instanceof RequiresResize)) continue;
            ((RequiresResize)containedWidget).onResize();
        }
    }

    private Widget makeItem(MenuItem item, boolean isRoot) {
        Object result;
        if (!this.authzManager.authorize((Resource)item, this.identity)) {
            return null;
        }
        if (item instanceof MenuItemCommand) {
            final MenuItemCommand cmdItem = (MenuItemCommand)item;
            if (isRoot) {
                final Button button = new Button(cmdItem.getCaption());
                button.setSize(ButtonSize.SMALL);
                button.setEnabled(item.isEnabled());
                button.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        cmdItem.getCommand().execute();
                    }
                });
                item.addEnabledStateChangeListener(new EnabledStateChangeListener(){

                    public void enabledStateChanged(boolean enabled) {
                        button.setEnabled(enabled);
                    }
                });
                return button;
            }
            final NavbarLink navbarLink = new NavbarLink();
            navbarLink.setText(cmdItem.getCaption());
            if (!item.isEnabled()) {
                navbarLink.addStyleName("disabled");
            }
            navbarLink.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    cmdItem.getCommand().execute();
                }
            });
            item.addEnabledStateChangeListener(new EnabledStateChangeListener(){

                public void enabledStateChanged(boolean enabled) {
                    if (enabled) {
                        navbarLink.removeStyleName("disabled");
                    } else {
                        navbarLink.addStyleName("disabled");
                    }
                }
            });
            return navbarLink;
        }
        if (item instanceof MenuGroup) {
            MenuGroup groups = (MenuGroup)item;
            if (isRoot) {
                ArrayList<Widget> widgetList = new ArrayList<Widget>();
                for (MenuItem _item : groups.getItems()) {
                    Widget widget = this.makeItem(_item, false);
                    if (widget == null) continue;
                    widgetList.add(widget);
                }
                if (widgetList.isEmpty()) {
                    return null;
                }
                return this.makeDropDownMenuButton(groups.getCaption(), widgetList);
            }
            ArrayList<Widget> widgetList = new ArrayList<Widget>();
            for (MenuItem _item : groups.getItems()) {
                Widget result2 = this.makeItem(_item, false);
                if (result2 == null) continue;
                widgetList.add(result2);
            }
            if (widgetList.isEmpty()) {
                return null;
            }
            return this.makeDropDownMenuButton(groups.getCaption(), widgetList);
        }
        if (item instanceof MenuCustom && (result = ((MenuCustom)item).build()) instanceof Widget) {
            return (Widget)result;
        }
        return null;
    }

    private Widget makeDropDownMenuButton(String caption, List<Widget> widgetList) {
        ButtonGroup buttonGroup = new ButtonGroup();
        Button dropdownButton = new Button(caption);
        dropdownButton.setDataToggle(Toggle.DROPDOWN);
        dropdownButton.setSize(ButtonSize.EXTRA_SMALL);
        DropDownMenu dropDownMenu = new DropDownMenu();
        for (Widget _item : widgetList) {
            dropDownMenu.add(_item);
        }
        buttonGroup.add((Widget)dropdownButton);
        buttonGroup.add((Widget)dropDownMenu);
        return buttonGroup;
    }

    private void scheduleResize() {
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                ListBarWidgetImpl.this.onResize();
            }
        });
    }

    public MaximizeToggleButtonPresenter getMaximizeButton() {
        return this.maximizeButtonPresenter;
    }

    public boolean isDndEnabled() {
        return this.titleDropDown.isDndEnabled();
    }

    static interface ListBarWidgetBinder
    extends UiBinder<ResizeFocusPanel, ListBarWidgetImpl> {
    }
}

