/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.util;

import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.inject.Typed;

@Typed
public abstract class ProxyUtils {
    private ProxyUtils() {
    }

    public static Class getUnproxiedClass(Class currentClass) {
        if (ProxyUtils.isProxiedClass(currentClass)) {
            return currentClass.getSuperclass();
        }
        return currentClass;
    }

    public static boolean isProxiedClass(Class currentClass) {
        if (currentClass == null || currentClass.getSuperclass() == null) {
            return false;
        }
        return currentClass.getName().startsWith(currentClass.getSuperclass().getName()) && currentClass.getName().contains("$$");
    }

    public static List<Class<?>> getProxyAndBaseTypes(Class<?> proxyClass) {
        ArrayList result = new ArrayList();
        result.add(proxyClass);
        if (ProxyUtils.isInterfaceProxy(proxyClass)) {
            result.addAll(Arrays.asList(proxyClass.getInterfaces()));
        } else {
            result.add(proxyClass.getSuperclass());
        }
        return result;
    }

    public static boolean isInterfaceProxy(Class<?> proxyClass) {
        Class<?>[] interfaces = proxyClass.getInterfaces();
        return Proxy.class.equals(proxyClass.getSuperclass()) && interfaces != null && interfaces.length > 0;
    }
}

