/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.future;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.future.SshFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSshFuture<T extends SshFuture>
implements SshFuture<T> {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Object CANCELED = new Object();
    private final Object lock;
    private SshFutureListener<T> firstListener;
    private List<SshFutureListener<T>> otherListeners;
    private Object result;
    private boolean ready;

    public DefaultSshFuture(Object lock) {
        this.lock = lock != null ? lock : this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T await() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (!this.ready) {
                this.lock.wait();
            }
        }
        return this.asT();
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.await(unit.toMillis(timeout));
    }

    @Override
    public boolean await(long timeoutMillis) throws InterruptedException {
        return this.await0(timeoutMillis, true);
    }

    @Override
    public T awaitUninterruptibly() {
        try {
            this.await0(Long.MAX_VALUE, false);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.asT();
    }

    @Override
    public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
        return this.awaitUninterruptibly(unit.toMillis(timeout));
    }

    @Override
    public boolean awaitUninterruptibly(long timeoutMillis) {
        try {
            return this.await0(timeoutMillis, false);
        }
        catch (InterruptedException e) {
            throw new InternalError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean await0(long timeoutMillis, boolean interruptable) throws InterruptedException {
        long curTime = System.currentTimeMillis();
        long endTime = Long.MAX_VALUE - timeoutMillis < curTime ? Long.MAX_VALUE : curTime + timeoutMillis;
        Object object = this.lock;
        synchronized (object) {
            if (this.ready || timeoutMillis <= 0L) {
                return this.ready;
            }
            do {
                block7: {
                    try {
                        this.lock.wait(endTime - curTime);
                    }
                    catch (InterruptedException e) {
                        if (!interruptable) break block7;
                        throw e;
                    }
                }
                curTime = System.currentTimeMillis();
            } while (!this.ready && curTime < endTime);
            return this.ready;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        Object object = this.lock;
        synchronized (object) {
            return this.ready;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(Object newValue) {
        Object object = this.lock;
        synchronized (object) {
            if (this.ready) {
                return;
            }
            this.result = newValue;
            this.ready = true;
            this.lock.notifyAll();
        }
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getValue() {
        Object object = this.lock;
        synchronized (object) {
            return this.result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T addListener(SshFutureListener<T> listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        boolean notifyNow = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.ready) {
                notifyNow = true;
            } else if (this.firstListener == null) {
                this.firstListener = listener;
            } else {
                if (this.otherListeners == null) {
                    this.otherListeners = new ArrayList<SshFutureListener<T>>(1);
                }
                this.otherListeners.add(listener);
            }
        }
        if (notifyNow) {
            this.notifyListener(listener);
        }
        return this.asT();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T removeListener(SshFutureListener<T> listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.ready) {
                if (listener == this.firstListener) {
                    this.firstListener = this.otherListeners != null && !this.otherListeners.isEmpty() ? this.otherListeners.remove(0) : null;
                } else if (this.otherListeners != null) {
                    this.otherListeners.remove(listener);
                }
            }
        }
        return this.asT();
    }

    private void notifyListeners() {
        if (this.firstListener != null) {
            this.notifyListener(this.firstListener);
            this.firstListener = null;
            if (this.otherListeners != null) {
                for (SshFutureListener<T> l : this.otherListeners) {
                    this.notifyListener(l);
                }
                this.otherListeners = null;
            }
        }
    }

    private void notifyListener(SshFutureListener<T> l) {
        try {
            l.operationComplete(this.asT());
        }
        catch (Throwable t) {
            this.logger.warn("Listener threw an exception", t);
        }
    }

    public boolean isCanceled() {
        return this.getValue() == CANCELED;
    }

    public void cancel() {
        this.setValue(CANCELED);
    }

    private T asT() {
        return (T)this;
    }
}

