/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.access;

import java.util.Collection;
import java.util.Iterator;
import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.Triple;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.access.security.TcAccessController;
import org.apache.clerezza.rdf.core.event.FilterTriple;
import org.apache.clerezza.rdf.core.event.GraphListener;

public class SecuredTripleCollection
implements TripleCollection {
    private final TripleCollection wrapped;
    private final UriRef name;
    private final TcAccessController tcAccessController;

    public SecuredTripleCollection(TripleCollection wrapped, UriRef name, TcAccessController tcAccessController) {
        this.wrapped = wrapped;
        this.name = name;
        this.tcAccessController = tcAccessController;
    }

    @Override
    public Iterator<Triple> filter(NonLiteral subject, UriRef predicate, Resource object) {
        final Iterator<Triple> baseIter = this.wrapped.filter(subject, predicate, object);
        return new Iterator<Triple>(){

            @Override
            public boolean hasNext() {
                SecuredTripleCollection.this.checkRead();
                return baseIter.hasNext();
            }

            @Override
            public Triple next() {
                SecuredTripleCollection.this.checkRead();
                return (Triple)baseIter.next();
            }

            @Override
            public void remove() {
                SecuredTripleCollection.this.checkWrite();
                baseIter.remove();
            }
        };
    }

    @Override
    public int size() {
        this.checkRead();
        return this.wrapped.size();
    }

    @Override
    public boolean isEmpty() {
        this.checkRead();
        return this.wrapped.isEmpty();
    }

    @Override
    public Object[] toArray() {
        this.checkRead();
        return this.wrapped.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.checkRead();
        return this.wrapped.toArray(a);
    }

    @Override
    public boolean add(Triple e) {
        this.checkWrite();
        return this.wrapped.add(e);
    }

    @Override
    public boolean remove(Object o) {
        this.checkWrite();
        return this.wrapped.remove(o);
    }

    @Override
    public boolean addAll(Collection<? extends Triple> c) {
        this.checkWrite();
        return this.wrapped.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.checkWrite();
        return this.wrapped.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.checkWrite();
        return this.wrapped.retainAll(c);
    }

    @Override
    public void clear() {
        this.checkWrite();
        this.wrapped.clear();
    }

    void checkRead() {
        this.tcAccessController.checkReadPermission(this.name);
    }

    void checkWrite() {
        this.tcAccessController.checkReadWritePermission(this.name);
    }

    @Override
    public boolean contains(Object o) {
        this.checkRead();
        return this.wrapped.contains((Triple)o);
    }

    @Override
    public void addGraphListener(GraphListener listener, FilterTriple filter, long delay) {
        this.checkRead();
        this.wrapped.addGraphListener(listener, filter, delay);
    }

    @Override
    public void addGraphListener(GraphListener listener, FilterTriple filter) {
        this.checkRead();
        this.wrapped.addGraphListener(listener, filter);
    }

    @Override
    public void removeGraphListener(GraphListener listener) {
        this.wrapped.removeGraphListener(listener);
    }

    @Override
    public Iterator<Triple> iterator() {
        return this.filter(null, null, null);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.checkRead();
        return this.wrapped.containsAll(c);
    }
}

