/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.widgets.split;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;
import org.uberfire.client.resources.WorkbenchResources;
import org.uberfire.client.workbench.widgets.listbar.ResizeFlowPanel;
import org.uberfire.workbench.model.CompassPosition;

public class WorkbenchSplitLayoutPanel
extends DockLayoutPanel {
    private static final int DEFAULT_SPLITTER_SIZE = 1;
    private static final int DEFAULT_SPLITTER_HOVER_SIZE = 10;
    private static Element glassElem = null;
    private final int splitterSize;
    private int minCenterSize = 0;

    public WorkbenchSplitLayoutPanel() {
        this(1);
    }

    public WorkbenchSplitLayoutPanel(int splitterSize) {
        super(Style.Unit.PX);
        this.splitterSize = splitterSize;
        this.setStyleName(WorkbenchResources.INSTANCE.CSS().splitLayoutPanel());
        if (glassElem == null) {
            glassElem = Document.get().createDivElement();
            glassElem.getStyle().setPosition(Style.Position.ABSOLUTE);
            glassElem.getStyle().setTop(0.0, Style.Unit.PX);
            glassElem.getStyle().setLeft(0.0, Style.Unit.PX);
            glassElem.getStyle().setMargin(0.0, Style.Unit.PX);
            glassElem.getStyle().setPadding(0.0, Style.Unit.PX);
            glassElem.getStyle().setBorderWidth(0.0, Style.Unit.PX);
            glassElem.getStyle().setProperty("background", "white");
            glassElem.getStyle().setOpacity(0.0);
        }
    }

    public int getSplitterSize() {
        return this.splitterSize;
    }

    public void insert(Widget child, DockLayoutPanel.Direction direction, double size, Widget before) {
        super.insert(child, direction, size, before);
        if (direction != DockLayoutPanel.Direction.CENTER) {
            this.insertSplitter(child, before);
        }
    }

    public boolean remove(Widget child) {
        assert (!(child instanceof Splitter)) : "Splitters may not be directly removed";
        int idx = this.getWidgetIndex(child);
        if (super.remove(child)) {
            if (idx < this.getWidgetCount()) {
                super.remove(this.getWidget(idx));
            }
            return true;
        }
        return false;
    }

    public void setWidgetMinSize(Widget child, int minSize) {
        this.assertIsAChild(child);
        Splitter splitter = this.getAssociatedSplitter(child);
        if (splitter != null) {
            splitter.setMinSize(minSize);
        } else {
            this.minCenterSize = minSize;
        }
    }

    private void assertIsAChild(Widget widget) {
        assert (widget == null || widget.getParent() == this) : "The specified widget is not a child of this panel";
    }

    private Splitter getAssociatedSplitter(Widget child) {
        int idx = this.getWidgetIndex(child);
        if (idx > -1 && idx < this.getWidgetCount() - 1) {
            Widget splitter = this.getWidget(idx + 1);
            assert (splitter instanceof Splitter) : "Expected child widget to be splitter";
            return (Splitter)splitter;
        }
        return null;
    }

    private void insertSplitter(Widget widget, Widget before) {
        assert (this.getChildren().size() > 0) : "Can't add a splitter before any children";
        DockLayoutPanel.LayoutData layout = (DockLayoutPanel.LayoutData)widget.getLayoutData();
        Splitter splitter = null;
        switch (this.getResolvedDirection(layout.direction)) {
            case WEST: {
                splitter = new HSplitter(widget, false);
                break;
            }
            case EAST: {
                splitter = new HSplitter(widget, true);
                break;
            }
            case NORTH: {
                splitter = new VSplitter(widget, false);
                break;
            }
            case SOUTH: {
                splitter = new VSplitter(widget, true);
                break;
            }
            default: {
                assert (false) : "Unexpected direction";
                break;
            }
        }
        super.insert((Widget)splitter, layout.direction, (double)this.splitterSize, before);
    }

    public void add(Widget child, CompassPosition position, double size) {
        switch (position) {
            case NORTH: {
                this.addNorth(child, size);
                break;
            }
            case SOUTH: {
                this.addSouth(child, size);
                break;
            }
            case EAST: {
                this.addEast(child, size);
                break;
            }
            case WEST: {
                this.addWest(child, size);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad child position: " + position);
            }
        }
    }

    public void add(Widget child, CompassPosition position, int size) {
        double doubleSize = size;
        this.add(child, position, doubleSize);
    }

    class VSplitter
    extends Splitter {
        public VSplitter(Widget target, boolean reverse) {
            super(target, reverse);
            this.setStyleName(WorkbenchResources.INSTANCE.CSS().splitLayoutPanelVDragger());
        }

        @Override
        protected void setUpHoverStyle(Style style, int size) {
            style.setHeight((double)size, Style.Unit.PX);
            style.setMarginTop((double)(-(size / 2)), Style.Unit.PX);
        }

        public void onResize() {
            this.hover.getElement().getStyle().setWidth((double)this.target.getOffsetWidth(), Style.Unit.PX);
        }

        @Override
        protected Style.Cursor getHoverCursorStyle() {
            return Style.Cursor.ROW_RESIZE;
        }

        @Override
        protected int getAbsolutePosition() {
            return this.getAbsoluteTop();
        }

        @Override
        protected double getCenterSize() {
            return WorkbenchSplitLayoutPanel.this.getCenterHeight();
        }

        @Override
        protected int getEventPosition(Event event) {
            return event.getClientY();
        }

        @Override
        protected int getTargetPosition() {
            return this.target.getAbsoluteTop();
        }

        @Override
        protected int getTargetSize() {
            return this.target.getOffsetHeight();
        }
    }

    abstract class Splitter
    extends Composite
    implements RequiresResize {
        protected final Widget target;
        protected final Widget hover;
        protected final Element mouseTracker;
        private int offset;
        private boolean mouseDown;
        private Scheduler.ScheduledCommand layoutCommand;
        private final boolean reverse;
        private int minSize;
        private double centerSize;
        private double syncedCenterSize;

        public Splitter(Widget target, boolean reverse) {
            this.target = target;
            this.reverse = reverse;
            ResizeFlowPanel widget = new ResizeFlowPanel();
            this.sinkEvents(78);
            this.hover = new FlowPanel();
            Style style = this.hover.getElement().getStyle();
            style.setOpacity(0.0);
            style.setZIndex(2);
            style.setPosition(Style.Position.FIXED);
            this.setUpHoverStyle(style, 10);
            widget.add(this.hover);
            this.initWidget((Widget)widget);
            this.mouseTracker = Document.get().createDivElement();
            this.mouseTracker.getStyle().setCursor(this.getHoverCursorStyle());
            this.mouseTracker.getStyle().setZIndex(Integer.MAX_VALUE);
            this.mouseTracker.getStyle().setPosition(Style.Position.ABSOLUTE);
            this.mouseTracker.getStyle().setHeight(50.0, Style.Unit.PX);
            this.mouseTracker.getStyle().setWidth(50.0, Style.Unit.PX);
        }

        public void onBrowserEvent(Event event) {
            switch (event.getTypeInt()) {
                case 4: {
                    this.mouseDown = true;
                    int width = Math.max(Window.getClientWidth(), Document.get().getScrollWidth());
                    int height = Math.max(Window.getClientHeight(), Document.get().getScrollHeight());
                    glassElem.getStyle().setHeight((double)height, Style.Unit.PX);
                    glassElem.getStyle().setWidth((double)width, Style.Unit.PX);
                    Document.get().getBody().appendChild((Node)glassElem);
                    this.offset = this.getEventPosition(event) - this.getAbsolutePosition();
                    Event.setCapture((Element)this.getElement());
                    event.preventDefault();
                    Document.get().getBody().appendChild((Node)this.mouseTracker);
                    break;
                }
                case 8: {
                    this.mouseDown = false;
                    glassElem.removeFromParent();
                    Event.releaseCapture((Element)this.getElement());
                    event.preventDefault();
                    this.mouseTracker.removeFromParent();
                    break;
                }
                case 64: {
                    if (!this.mouseDown) break;
                    int size = this.reverse ? this.getTargetPosition() + this.getTargetSize() - this.getEventPosition(event) - this.offset : this.getEventPosition(event) - this.getTargetPosition() - this.offset;
                    this.setAssociatedWidgetSize(size);
                    event.preventDefault();
                    this.mouseTracker.getStyle().setLeft((double)(event.getClientX() - this.mouseTracker.getOffsetWidth() / 2), Style.Unit.PX);
                    this.mouseTracker.getStyle().setTop((double)(event.getClientY() - this.mouseTracker.getOffsetHeight() / 2), Style.Unit.PX);
                }
            }
        }

        public void setMinSize(int minSize) {
            this.minSize = minSize;
            DockLayoutPanel.LayoutData layout = (DockLayoutPanel.LayoutData)this.target.getLayoutData();
            this.setAssociatedWidgetSize((int)layout.size);
        }

        protected abstract void setUpHoverStyle(Style var1, int var2);

        protected abstract Style.Cursor getHoverCursorStyle();

        protected abstract int getAbsolutePosition();

        protected abstract double getCenterSize();

        protected abstract int getEventPosition(Event var1);

        protected abstract int getTargetPosition();

        protected abstract int getTargetSize();

        private double getMaxSize() {
            double newCenterSize = this.getCenterSize();
            if (this.syncedCenterSize != newCenterSize) {
                this.syncedCenterSize = newCenterSize;
                this.centerSize = newCenterSize;
            }
            return Math.max(((DockLayoutPanel.LayoutData)this.target.getLayoutData()).size + this.centerSize, 0.0);
        }

        private void setAssociatedWidgetSize(double size) {
            double maxSize = this.getMaxSize();
            if (size > maxSize) {
                size = maxSize;
            }
            if (size < (double)this.minSize) {
                size = this.minSize;
            }
            DockLayoutPanel.LayoutData layout = (DockLayoutPanel.LayoutData)this.target.getLayoutData();
            if (size == layout.size) {
                return;
            }
            double newCenterSize = this.centerSize + (layout.size - size);
            if (newCenterSize < (double)WorkbenchSplitLayoutPanel.this.minCenterSize) {
                return;
            }
            this.centerSize += layout.size - size;
            this.centerSize = newCenterSize;
            layout.size = size;
            if (this.layoutCommand == null) {
                this.layoutCommand = new Command(){

                    public void execute() {
                        Splitter.this.layoutCommand = null;
                        WorkbenchSplitLayoutPanel.this.forceLayout();
                    }
                };
                Scheduler.get().scheduleDeferred(this.layoutCommand);
            }
        }
    }

    class HSplitter
    extends Splitter {
        public HSplitter(Widget target, boolean reverse) {
            super(target, reverse);
            this.setStyleName(WorkbenchResources.INSTANCE.CSS().splitLayoutPanelHDragger());
        }

        @Override
        protected void setUpHoverStyle(Style style, int size) {
            style.setWidth((double)size, Style.Unit.PX);
            style.setMarginLeft((double)(-(size / 2)), Style.Unit.PX);
        }

        public void onResize() {
            this.hover.getElement().getStyle().setHeight((double)this.target.getOffsetHeight(), Style.Unit.PX);
        }

        @Override
        protected Style.Cursor getHoverCursorStyle() {
            return Style.Cursor.COL_RESIZE;
        }

        @Override
        protected int getAbsolutePosition() {
            return this.getAbsoluteLeft();
        }

        @Override
        protected double getCenterSize() {
            return WorkbenchSplitLayoutPanel.this.getCenterWidth();
        }

        @Override
        protected int getEventPosition(Event event) {
            return event.getClientX();
        }

        @Override
        protected int getTargetPosition() {
            return this.target.getAbsoluteLeft();
        }

        @Override
        protected int getTargetSize() {
            return this.target.getOffsetWidth();
        }
    }
}

