/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.relocated.freemarker.core;

import java.io.IOException;
import org.uberfire.relocated.freemarker.core.Environment;
import org.uberfire.relocated.freemarker.core.Expression;
import org.uberfire.relocated.freemarker.core.ListLiteral;
import org.uberfire.relocated.freemarker.core.StringLiteral;
import org.uberfire.relocated.freemarker.core.TemplateElement;
import org.uberfire.relocated.freemarker.template.SimpleSequence;
import org.uberfire.relocated.freemarker.template.TemplateException;
import org.uberfire.relocated.freemarker.template.TemplateHashModel;
import org.uberfire.relocated.freemarker.template.TemplateModel;
import org.uberfire.relocated.freemarker.template.TemplateNodeModel;
import org.uberfire.relocated.freemarker.template.TemplateScalarModel;
import org.uberfire.relocated.freemarker.template.TemplateSequenceModel;

final class RecurseNode
extends TemplateElement {
    Expression targetNode;
    Expression namespaces;

    RecurseNode(Expression targetNode, Expression namespaces) {
        this.targetNode = targetNode;
        this.namespaces = namespaces;
    }

    void accept(Environment env) throws IOException, TemplateException {
        TemplateModel nss;
        TemplateModel node = this.targetNode == null ? null : this.targetNode.getAsTemplateModel(env);
        TemplateModel templateModel = nss = this.namespaces == null ? null : this.namespaces.getAsTemplateModel(env);
        if (this.namespaces instanceof StringLiteral) {
            nss = env.importLib(((TemplateScalarModel)nss).getAsString(), null);
        } else if (this.namespaces instanceof ListLiteral) {
            nss = ((ListLiteral)this.namespaces).evaluateStringsToNamespaces(env);
        }
        if (node != null && !(node instanceof TemplateNodeModel)) {
            throw new TemplateException("Expecting an XML node here, for expression: " + this.targetNode + ", found a: " + node.getClass().getName(), env);
        }
        if (nss != null) {
            if (nss instanceof TemplateHashModel) {
                SimpleSequence ss = new SimpleSequence(1);
                ss.add(nss);
                nss = ss;
            } else if (!(nss instanceof TemplateSequenceModel)) {
                throw new TemplateException("Expecting a sequence of namespaces after 'using'", env);
            }
        }
        env.recurse((TemplateNodeModel)node, (TemplateSequenceModel)nss);
    }

    public String getCanonicalForm() {
        String result = "<#recurse";
        if (this.targetNode != null) {
            result = result + " " + this.targetNode.getCanonicalForm();
        }
        if (this.namespaces != null) {
            result = result + " using " + this.namespaces.getCanonicalForm();
        }
        return result + "/>";
    }

    public String getDescription() {
        return "recurse instruction";
    }
}

