/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.access;

import java.security.AccessControlException;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.clerezza.rdf.core.Graph;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.access.LockableMGraph;
import org.apache.clerezza.rdf.core.access.SecuredTripleCollection;
import org.apache.clerezza.rdf.core.access.security.TcAccessController;
import org.apache.clerezza.rdf.core.impl.SimpleGraph;
import org.apache.clerezza.rdf.core.impl.WriteBlockedMGraph;

public class SecuredMGraph
extends SecuredTripleCollection
implements LockableMGraph {
    private LockableMGraph wrapped;

    public SecuredMGraph(LockableMGraph wrapped, UriRef name, TcAccessController tcAccessController) {
        super(wrapped, name, tcAccessController);
        this.wrapped = wrapped;
    }

    @Override
    public Graph getGraph() {
        return new SimpleGraph(this);
    }

    @Override
    public ReadWriteLock getLock() {
        return this.wrapped.getLock();
    }

    public LockableMGraph getUnsecuredMGraph() {
        try {
            this.checkWrite();
            return this.wrapped;
        }
        catch (AccessControlException ex) {
            this.checkRead();
            return new WriteBlockedMGraph(this.wrapped);
        }
    }
}

