/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.impl.authz;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.commons.data.Cacheable;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.security.Resource;
import org.uberfire.security.annotations.All;
import org.uberfire.security.annotations.Authorized;
import org.uberfire.security.annotations.Deny;
import org.uberfire.security.authz.AuthorizationResult;
import org.uberfire.security.authz.GroupsResource;
import org.uberfire.security.authz.ProfileDecisionManager;
import org.uberfire.security.authz.ProfilesResource;
import org.uberfire.security.authz.ResourceDecisionManager;
import org.uberfire.security.authz.RolesResource;
import org.uberfire.security.authz.RuntimeResource;
import org.uberfire.security.authz.VotingStrategy;
import org.uberfire.security.impl.authz.AffirmativeBasedVoter;
import org.uberfire.security.impl.authz.RuntimeResourceManager;
import org.uberfire.security.impl.authz.UnanimousBasedVoter;

public class RuntimeResourceDecisionManager
implements ResourceDecisionManager {
    private static final UnanimousBasedVoter ALL_VOTER = new UnanimousBasedVoter();
    private static final AffirmativeBasedVoter DEFAULT_VOTER = new AffirmativeBasedVoter();
    private final RuntimeAuthzCache cache = new RuntimeAuthzCache();
    private final RuntimeResourceManager resourceManager;

    public RuntimeResourceDecisionManager(RuntimeResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    @Override
    public boolean supports(Resource resource) {
        if (resource == null) {
            return false;
        }
        return resource instanceof RuntimeResource;
    }

    @Override
    public AuthorizationResult decide(Resource resource, User user, ProfileDecisionManager profileDecisionManager) {
        RuntimeResource runtimeResource;
        PortablePreconditions.checkNotNull((String)"profileDecisionManager", (Object)profileDecisionManager);
        if (!(resource instanceof RuntimeResource)) {
            throw new IllegalArgumentException("Parameter named 'resource' is not instance of clazz 'RuntimeResource'!");
        }
        boolean refreshCache = false;
        if (resource instanceof Cacheable) {
            refreshCache = ((Cacheable)resource).requiresRefresh();
        }
        if (this.cache.notContains(user, runtimeResource = (RuntimeResource)resource) || refreshCache) {
            if (!this.resourceManager.requiresAuthentication((Resource)runtimeResource)) {
                return AuthorizationResult.ACCESS_ABSTAIN;
            }
            final RuntimeResourceManager.RuntimeRestriction restriction = this.resourceManager.getRestriction(runtimeResource);
            if (restriction == null || restriction.isEmpty()) {
                return AuthorizationResult.ACCESS_ABSTAIN;
            }
            boolean invertResult = false;
            VotingStrategy votingStrategy = null;
            for (String trait : restriction.getTraits()) {
                if (trait.equals(All.class.getName())) {
                    votingStrategy = ALL_VOTER;
                    continue;
                }
                if (trait.equals(Authorized.class.getName())) {
                    if (user == null) continue;
                    return AuthorizationResult.ACCESS_GRANTED;
                }
                if (!trait.equals(Deny.class.getName())) continue;
                invertResult = true;
            }
            if (votingStrategy == null) {
                votingStrategy = DEFAULT_VOTER;
            }
            ProfilesResource profilesResource = null;
            if (restriction instanceof RuntimeResourceManager.FeatureRestriction) {
                profilesResource = new RolesResource(){

                    @Override
                    public Collection<Role> getRoles() {
                        return ((RuntimeResourceManager.FeatureRestriction)restriction).getRoles();
                    }
                };
            } else if (restriction instanceof RuntimeResourceManager.ContentRestriction) {
                profilesResource = new GroupsResource(){

                    @Override
                    public Collection<Group> getGroups() {
                        return ((RuntimeResourceManager.ContentRestriction)restriction).getGroups();
                    }
                };
            }
            AuthorizationResult result = votingStrategy.vote(profileDecisionManager.decide(profilesResource, user));
            if (invertResult) {
                this.cache.put(user, runtimeResource, result.invert());
            } else {
                this.cache.put(user, runtimeResource, result);
            }
            if (resource instanceof Cacheable) {
                ((Cacheable)resource).markAsCached();
            }
        }
        return this.cache.get(user, runtimeResource);
    }

    class RuntimeAuthzCache {
        final Map<String, Map<String, AuthorizationResult>> internal = new HashMap<String, Map<String, AuthorizationResult>>();

        RuntimeAuthzCache() {
        }

        public boolean notContains(User user, RuntimeResource resource) {
            Map<String, AuthorizationResult> result = this.internal.get(resource.getSignatureId());
            if (result == null) {
                return true;
            }
            return !result.containsKey(user.getIdentifier());
        }

        public void put(User user, RuntimeResource resource, AuthorizationResult authzResult) {
            if (!this.internal.containsKey(resource.getSignatureId())) {
                this.internal.put(resource.getSignatureId(), new HashMap());
            }
            Map<String, AuthorizationResult> result = this.internal.get(resource.getSignatureId());
            AuthorizationResult knowValue = result.get(user.getIdentifier());
            if (result.containsKey(user.getIdentifier()) && knowValue.equals(authzResult)) {
                return;
            }
            result.put(user.getIdentifier(), authzResult);
        }

        public AuthorizationResult get(User user, RuntimeResource resource) {
            Map<String, AuthorizationResult> result = this.internal.get(resource.getSignatureId());
            if (result == null) {
                return AuthorizationResult.ACCESS_DENIED;
            }
            AuthorizationResult decision = result.get(user.getIdentifier());
            if (decision == null) {
                return AuthorizationResult.ACCESS_DENIED;
            }
            return decision;
        }
    }
}

